package com.xebialabs.deployit.repository.test

import com.xebialabs.deployit.core.config.{SqlConfiguration, TaskerSystemProperties, XldSpringConfig}
import com.xebialabs.deployit.util.PasswordEncrypter
import org.springframework.beans.factory.annotation.Configurable
import org.springframework.context.annotation.{Bean, ComponentScan, Import}

@Configurable
@ComponentScan(Array(
  "com.xebialabs.deployit.engine.tasker.repository.sql"
))
@Import(Array(
  classOf[SqlConfiguration],
  classOf[TaskerSystemProperties],
  classOf[XldSpringConfig],
))
class SqlTestConfig {

  @Bean
  def passwordEncrypter: PasswordEncrypter  = PasswordEncrypter.getInstance()

}
