/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.repository.sql;

import ai.digital.deploy.task.status.TaskPathStatusStore;
import ai.digital.deploy.task.steplog.TaskStepLogStore;
import akka.actor.ActorPath;
import com.xebialabs.deployit.core.sql.Db2Dialect$;
import com.xebialabs.deployit.core.sql.DerbyDialect$;
import com.xebialabs.deployit.core.sql.OracleDialect$;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.dto.Worker;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTask;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.sql.SqlCrudTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.sql.package$;
import com.xebialabs.deployit.sql.base.schema.ActiveTaskMetadataSchema$;
import com.xebialabs.deployit.sql.base.schema.ActiveTaskSchema$;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001\u0002\u000b\u0016\u0001\u0011B\u0011b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\"\t\u0013I\u0003!\u0011!Q\u0001\nMK\u0006\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0001/\t\u0011\u0015\u0004!\u0011!Q\u0001\nuC\u0001B\u001a\u0001\u0003\u0006\u0004%\te\u001a\u0005\na\u0002\u0011\t\u0011)A\u0005QFD\u0001B\u001d\u0001\u0003\u0006\u0004%\u0019e\u001d\u0005\nu\u0002\u0011\t\u0011)A\u0005inDQ\u0001 \u0001\u0005\u0002uDq!!\u000b\u0001\t\u0003\nY\u0003C\u0004\u0002\u0006\u0002!\t%a\"\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u00111\u0016\u0001\u0005\n\u00055\u0006bBAj\u0001\u0011\u0005\u0013Q\u001b\u0005\b\u00037\u0004A\u0011IAo\u0011\u001d\t\t\u000f\u0001C!\u0003GDq!!<\u0001\t\u0003\ny\u000fC\u0004\u0002t\u0002!\t%!>\t\u000f\u0005e\b\u0001\"\u0011\u0002|\n92+\u001d7BGRLg/\u001a+bg.\u0014V\r]8tSR|'/\u001f\u0006\u0003-]\t1a]9m\u0015\tA\u0012$\u0001\u0006sKB|7/\u001b;pefT!AG\u000e\u0002\rQ\f7o[3s\u0015\taR$\u0001\u0004f]\u001eLg.\u001a\u0006\u0003=}\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003A\u0005\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\t\n1aY8n\u0007\u0001\u0019R\u0001A\u0013*[A\u0002\"AJ\u0014\u000e\u0003UI!\u0001K\u000b\u0003+M\u000bHn\u0011:vIR\u000b7o\u001b*fa>\u001c\u0018\u000e^8ssB\u0011!fK\u0007\u0002/%\u0011Af\u0006\u0002\u0015\u0003\u000e$\u0018N^3UCN\\'+\u001a9pg&$xN]=\u0011\u0005\u0019r\u0013BA\u0018\u0016\u0005E\t5\r^5wKR\u000b7o[)vKJLWm\u001d\t\u0003MEJ!AM\u000b\u00033\u0005\u001bG/\u001b<f)\u0006\u001c8.T3uC\u0012\fG/Y)vKJLWm]\u0001\u0014i\u0006\u001c8\u000eU1uQN#\u0018\r^;t'R|'/\u001a\t\u0003k\u0001k\u0011A\u000e\u0006\u0003oa\naa\u001d;biV\u001c(BA\u001d;\u0003\u0011!\u0018m]6\u000b\u0005mb\u0014A\u00023fa2|\u0017P\u0003\u0002>}\u00059A-[4ji\u0006d'\"A \u0002\u0005\u0005L\u0017BA!7\u0005M!\u0016m]6QCRD7\u000b^1ukN\u001cFo\u001c:f\u0013\t\u0019t\u0005\u000b\u0002\u0002\tB\u0011Q\tU\u0007\u0002\r*\u0011q\tS\u0001\u000bC:tw\u000e^1uS>t'BA%K\u0003\u001d1\u0017m\u0019;pefT!a\u0013'\u0002\u000b\t,\u0017M\\:\u000b\u00055s\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003=\u000b1a\u001c:h\u0013\t\tfIA\u0005BkR|w/\u001b:fI\u0006\u0001B/Y:l'R,\u0007\u000fT8h'R|'/\u001a\t\u0003)^k\u0011!\u0016\u0006\u0003-b\nqa\u001d;fa2|w-\u0003\u0002Y+\n\u0001B+Y:l'R,\u0007\u000fT8h'R|'/Z\u0005\u0003%\u001eB#A\u0001#\u0002!]|'o[3s%\u0016\u0004xn]5u_JLX#A/\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017\u0001\u00043jgR\u0014\u0018NY;uS>t'B\u00012\u001c\u0003\r\t\u0007/[\u0005\u0003I~\u0013Q\u0004V1tW\u0016CXmY;uS>twk\u001c:lKJ\u0014V\r]8tSR|'/_\u0001\u0012o>\u00148.\u001a:SKB|7/\u001b;pef\u0004\u0013\u0001\u00046eE\u000e$V-\u001c9mCR,W#\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017\u0001B2pe\u0016T!!\u001c'\u0002\t)$'mY\u0005\u0003_*\u0014AB\u00133cGR+W\u000e\u001d7bi\u0016\fQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0013B\u00014(\u0003)\u00198\r[3nC&sgm\\\u000b\u0002iB\u0011Q\u000f_\u0007\u0002m*\u0011ac\u001e\u0006\u0003WvI!!\u001f<\u0003\u0015M\u001b\u0007.Z7b\u0013:4w.A\u0006tG\",W.Y%oM>\u0004\u0013B\u0001:(\u0003\u0019a\u0014N\\5u}QIa0a\u0005\u0002\u0018\u0005m\u0011q\u0004\u000b\u0004\u007f\u0006\u0005\u0001C\u0001\u0014\u0001\u0011\u0015\u0011\u0018\u0002q\u0001uQ!\t\t!!\u0002\u0002\f\u00055\u0001cA#\u0002\b%\u0019\u0011\u0011\u0002$\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017EAA\b\u0003)i\u0017-\u001b8TG\",W.\u0019\u0015\u0004\u0003\u0003!\u0005\"B\u001a\n\u0001\u0004!\u0004fAA\n\t\")!+\u0003a\u0001'\"\u001a\u0011q\u0003#\t\u000bmK\u0001\u0019A/)\u0007\u0005mA\tC\u0003g\u0013\u0001\u0007\u0001\u000e\u000b\u0005\u0002 \u0005\u0015\u00111BA\u0012C\t\t)#\u0001\tnC&t'\n\u001a2d)\u0016l\u0007\u000f\\1uK\"\u001a\u0011q\u0004#\u0002\u000bM$xN]3\u0015\u0011\u00055\u0012\u0011HA3\u0003c\u0002B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0003\u0003g\tQa]2bY\u0006LA!a\u000e\u00022\t!QK\\5u\u0011\u001d\tYD\u0003a\u0001\u0003{\ta\u0001^1tW&#\u0007\u0003BA \u0003?rA!!\u0011\u0002\\9!\u00111IA-\u001d\u0011\t)%a\u0016\u000f\t\u0005\u001d\u0013Q\u000b\b\u0005\u0003\u0013\n\u0019F\u0004\u0003\u0002L\u0005ESBAA'\u0015\r\tyeI\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!\u0001I\u0011\n\u0005yy\u0012B\u0001\u000f\u001e\u0013\tQ2$C\u0002\u0002^e\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002b\u0005\r$A\u0002+bg.LEMC\u0002\u0002^eAq!a\u001a\u000b\u0001\u0004\tI'\u0001\u0003ta\u0016\u001c\u0007\u0003BA6\u0003[j\u0011!G\u0005\u0004\u0003_J\"!\u0005+bg.\u001c\u0006/Z2jM&\u001c\u0017\r^5p]\"9\u00111\u000f\u0006A\u0002\u0005U\u0014\u0001\u00029bi\"\u0004B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0003bGR|'O\u0003\u0002\u0002\u0000\u0005!\u0011m[6b\u0013\u0011\t\u0019)!\u001f\u0003\u0013\u0005\u001bGo\u001c:QCRD\u0017aC2iC:<WmT<oKJ$b!!\f\u0002\n\u0006-\u0005bBA\u001e\u0017\u0001\u0007\u0011Q\b\u0005\b\u0003\u001b[\u0001\u0019AAH\u0003!qWm^(x]\u0016\u0014\b\u0003BAI\u00033sA!a%\u0002\u0016B!\u00111JA\u0019\u0013\u0011\t9*!\r\u0002\rA\u0013X\rZ3g\u0013\u0011\tY*!(\u0003\rM#(/\u001b8h\u0015\u0011\t9*!\r\u0002\u001b]|'o[3s\u0003\u0012$'/Z:t)\u0011\t\u0019+!+\u0011\r\u0005=\u0012QUAH\u0013\u0011\t9+!\r\u0003\r=\u0003H/[8o\u0011\u001d\tY\u0004\u0004a\u0001\u0003{\tA\"\u001a=fGV$X-U;fef$b!a,\u0002F\u0006%\u0007\u0003CAI\u0003c\u000by)!.\n\t\u0005M\u0016Q\u0014\u0002\u0004\u001b\u0006\u0004\bCBA\\\u0003\u007f\u000byI\u0004\u0003\u0002:\u0006uf\u0002BA&\u0003wK!!a\r\n\t\u0005u\u0013\u0011G\u0005\u0005\u0003\u0003\f\u0019M\u0001\u0003MSN$(\u0002BA/\u0003cAq!a2\u000e\u0001\u0004\ty)A\u0003rk\u0016\u0014\u0018\u0010C\u0004\u0002L6\u0001\r!!4\u0002\u000fQ\f7o[%egB1\u0011qWAh\u0003{IA!!5\u0002D\nA\u0011\n^3sC\ndW-\u0001\u000bdSB\u000bG\u000f[:Cs\u0012+\u0007\u000f\\8z[\u0016tGo\u001d\u000b\u0005\u0003_\u000b9\u000eC\u0004\u0002L:\u0001\r!!7\u0011\r\u0005]\u0016qXA\u001f\u0003U\u0019\u0017\u000eU1uQN\u0014\u0015pQ8oiJ|G\u000eV1tWN$B!a,\u0002`\"9\u00111Z\bA\u0002\u0005e\u0017a\u0004;bg.\u001cx+\u001b;i'R\fG/^:\u0015\u0005\u0005\u0015\bCBA\\\u0003\u007f\u000b9\u000fE\u0002+\u0003SL1!a;\u0018\u0005)\t5\r^5wKR\u000b7o[\u0001\u0010e\u0016\u001cwN\u001d3Ti\u0006\u0014H\u000fR1uKR!\u0011QFAy\u0011\u001d\tY$\u0005a\u0001\u0003{\tAC]3d_J$7i\\7qY\u0016$\u0018n\u001c8ECR,G\u0003BA\u0017\u0003oDq!a\u000f\u0013\u0001\u0004\ti$A\u0006va\u0012\fG/Z*uCR,GCBA\u0017\u0003{\fy\u0010C\u0004\u0002<M\u0001\r!!\u0010\t\u000f\t\u00051\u00031\u0001\u0002\u0010\u0006)1\u000f^1uK\":\u0001A!\u0002\u0002\f\tM\u0001\u0003\u0002B\u0004\u0005\u001fi!A!\u0003\u000b\u0007\u001d\u0013YAC\u0002\u0003\u000e1\u000b1\u0002\u001e:b]N\f7\r^5p]&!!\u0011\u0003B\u0005\u00055!&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u0012!QC\u0001\u0017[\u0006Lg\u000e\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\"\u001a\u0001A!\u0007\u0011\t\tm!\u0011E\u0007\u0003\u0005;Q1Aa\bM\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005G\u0011iBA\u0005D_6\u0004xN\\3oi\u0002")
public class SqlActiveTaskRepository
extends SqlCrudTaskRepository
implements ActiveTaskRepository {
    private final TaskExecutionWorkerRepository workerRepository;

    public TaskExecutionWorkerRepository workerRepository() {
        return this.workerRepository;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return super.jdbcTemplate();
    }

    @Override
    public SchemaInfo schemaInfo() {
        return super.schemaInfo();
    }

    public void store(String taskId, TaskSpecification spec, ActorPath path) {
        String workerAddress = path.address().toString();
        this.workerRepository().getWorkerByAddress(workerAddress).orElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(43).append("Worker with ").append(workerAddress).append(" not found in worker repository").toString());
        }).foreach((Function1 & Serializable)worker -> {
            SqlActiveTaskRepository.$anonfun$store$2(this, spec, taskId, worker);
            return BoxedUnit.UNIT;
        });
    }

    public void changeOwner(String taskId, String newOwner) {
        this.jdbcTemplate().update(this.UPDATE_OWNER(), new Object[]{newOwner, taskId});
    }

    public Option<String> workerAddress(String taskId) {
        return package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT_WORKER_ADDRESS(), (rs, x$1) -> rs.getString(1), new Object[]{taskId}));
    }

    private scala.collection.immutable.Map<String, List<String>> executeQuery(String query, Iterable<String> taskIds) {
        return com.xebialabs.deployit.core.sql.util.package$.MODULE$.queryStringWithInClause(taskIds, query, this.SqlBuilderHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"task.", ""}))).sqlb((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ActiveTaskMetadataSchema$.MODULE$.task_id()})), "taskIdsInClause", (Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(x$2, (rs, rowNum) -> new Tuple2((Object)rs.getString(1), (Object)rs.getString(2)))).asScala().toList(), this.schemaInfo()).groupBy((Function1 & Serializable)x$3 -> (String)x$3._1()).view().mapValues((Function1 & Serializable)x$4 -> x$4.map((Function1 & Serializable)x$5 -> (String)x$5._2())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<String, List<String>> ciPathsByDeployments(List<String> taskIds) {
        SqlDialect sqlDialect = this.schemaInfo().sqlDialect();
        boolean bl = DerbyDialect$.MODULE$.equals(sqlDialect) ? true : (OracleDialect$.MODULE$.equals(sqlDialect) ? true : Db2Dialect$.MODULE$.equals(sqlDialect));
        scala.collection.immutable.Map<String, List<String>> map = bl ? this.executeQuery(this.ORACLE_OR_DERBY_SELECT_CI_PATHS_BY_DEPL_TASK_ID(), (Iterable<String>)taskIds) : this.executeQuery(this.SELECT_CI_PATHS_BY_DEPL_TASK_ID(), (Iterable<String>)taskIds);
        return map;
    }

    public scala.collection.immutable.Map<String, List<String>> ciPathsByControlTasks(List<String> taskIds) {
        SqlDialect sqlDialect = this.schemaInfo().sqlDialect();
        boolean bl = DerbyDialect$.MODULE$.equals(sqlDialect) ? true : (OracleDialect$.MODULE$.equals(sqlDialect) ? true : Db2Dialect$.MODULE$.equals(sqlDialect));
        scala.collection.immutable.Map<String, List<String>> map = bl ? this.executeQuery(this.ORACLE_OR_DERBY_SELECT_CI_PATHS_BY_CONTROL_TASK_ID(), (Iterable<String>)taskIds) : this.executeQuery(this.SELECT_CI_PATHS_BY_CONTROL_TASK_ID(), (Iterable<String>)taskIds);
        return map;
    }

    public List<ActiveTask> tasksWithStatus() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().queryForList(this.SELECT_ALL_TASKS_WITH_SUMMARY())).asScala().groupBy((Function1 & Serializable)x$6 -> (String)x$6.get(ActiveTaskSchema$.MODULE$.task_id().name())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String taskId = (String)tuple2._1();
            Buffer list = (Buffer)tuple2._2();
            java.util.Map firstElement = (java.util.Map)list.headOption().getOrElse((Function0 & Serializable)() -> {
                throw new NoSuchElementException(new StringBuilder(27).append("No active task with taskId ").append(taskId).toString());
            });
            String taskDescription = (String)firstElement.get(ActiveTaskSchema$.MODULE$.description().name());
            String owner = (String)firstElement.get(ActiveTaskSchema$.MODULE$.task_owner().name());
            Integer workerId = com.xebialabs.deployit.core.sql.package$.MODULE$.asInteger(firstElement.get(ActiveTaskSchema$.MODULE$.worker_id().name()));
            TaskExecutionState status = TaskExecutionState.valueOf((String)((String)firstElement.get(ActiveTaskSchema$.MODULE$.state().name())));
            DateTime startDate = (DateTime)Option$.MODULE$.apply(firstElement.get(ActiveTaskSchema$.MODULE$.startDate().name())).map((Function1 & Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime((Timestamp)t)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            DateTime completionDate = (DateTime)Option$.MODULE$.apply(firstElement.get(ActiveTaskSchema$.MODULE$.completionDate().name())).map((Function1 & Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime((Timestamp)t)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            java.util.Map metadata = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)list.map((Function1 & Serializable)m -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((String)m.get(ActiveTaskMetadataSchema$.MODULE$.metadata_key().name()))), (Object)((String)m.get(ActiveTaskMetadataSchema$.MODULE$.metadata_value().name()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            ActiveTask activeTask = new ActiveTask(taskId, taskDescription, owner, metadata, workerId, status, startDate, completionDate);
            return activeTask;
        })).toList();
    }

    public void recordStartDate(String taskId) {
        this.jdbcTemplate().update(this.SET_START_DATE(), new Object[]{com.xebialabs.deployit.core.sql.package$.MODULE$.toTimestamp(DateTime.now()), taskId});
    }

    public void recordCompletionDate(String taskId) {
        this.jdbcTemplate().update(this.SET_COMPLETION_DATE(), new Object[]{com.xebialabs.deployit.core.sql.package$.MODULE$.toTimestamp(DateTime.now()), taskId});
    }

    public void updateState(String taskId, String state) {
        this.jdbcTemplate().update(this.UPDATE_STATE(), new Object[]{state, taskId});
    }

    public static final /* synthetic */ void $anonfun$store$2(SqlActiveTaskRepository $this, TaskSpecification spec$1, String taskId$1, Worker worker) {
        spec$1.getMetadata().put("worker_name", worker.name());
        $this.store(taskId$1, spec$1.getDescription(), spec$1.getOwner().getName(), worker.id(), spec$1.getMetadata());
    }

    public SqlActiveTaskRepository(@Autowired TaskPathStatusStore taskPathStatusStore, @Autowired TaskStepLogStore taskStepLogStore, @Autowired TaskExecutionWorkerRepository workerRepository, @Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSchema") SchemaInfo schemaInfo) {
        this.workerRepository = workerRepository;
        super(taskPathStatusStore, taskStepLogStore, jdbcTemplate, schemaInfo);
    }
}

