package ai.digital.deploy.engine.tasker.service

import com.xebialabs.deployit.core.events.TaskStepLogEvent
import com.xebialabs.deployit.engine.api.dto.TaskStepLog
import com.xebialabs.deployit.engine.tasker.TaskId

trait TaskStepLogService {

  def findOne(taskId: TaskId, stepPath: String): TaskStepLog

  def batchCreate(taskStepLogs: Seq[TaskStepLogEvent], updateTime: Long): Unit

  def create(taskStepLog: TaskStepLogEvent, updateTime: Long): Unit

  def delete(taskId: TaskId): Unit

  def findAll(taskId: TaskId): List[TaskStepLog]

}
