/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.repository.sql;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SimpleSelectBuilder;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.spring.Setter$;
import com.xebialabs.deployit.core.util.TypeConversions$;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.PendingTask;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTasksQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.package$;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.altoo.akka.serialization.kryo.KryoAkkaSerializer;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0005\t-f\u0001B\u0010!\u0001=B\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t/\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0001\f\u0001BC\u0002\u0013\r\u0011\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003[\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u001d\tI\u0003\u0001C!\u0003WAq!!\f\u0001\t\u0003\ny\u0003C\u0004\u0002:\u0001!\t%a\u000f\t\u0013\u0005E\u0004!%A\u0005\u0002\u0005M\u0004bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\b\u0003\u001b\u0003A\u0011BAH\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!!*\u0001\t\u0013\t9\u000bC\u0005\u0002n\u0002\t\n\u0011\"\u0003\u0002t!9\u0011q\u001e\u0001\u0005\u0002\u0005E\bb\u0002B\u0001\u0001\u0011\u0005#1\u0001\u0005\b\u0005\u001f\u0001A\u0011\u0002B\t\u0011)\u0011)\u0002\u0001EC\u0002\u0013%!q\u0003\u0005\b\u0005k\u0001A\u0011\tB\u001c\u0011\u001d\u0011y\u0004\u0001C!\u0005\u0003BqA!\u0012\u0001\t\u0003\u00129\u0005C\u0004\u0003P\u0001!\tE!\u0015\t\u000f\tU\u0003\u0001\"\u0011\u0003X!9!Q\r\u0001\u0005\n\t\u001d\u0004b\u0002B6\u0001\u0011%!Q\u000e\u0005\b\u0005c\u0002A\u0011\u0002B:\u0011\u001d\u00119\b\u0001C\u0005\u0005sBqA! \u0001\t\u0013\u0011y\bC\u0004\u0003\u0004\u0002!IA!\"\u00031M\u000bH\u000eU3oI&tw\rV1tWJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011QEJ\u0001\u0007i\u0006\u001c8.\u001a:\u000b\u0005\u001dB\u0013AB3oO&tWM\u0003\u0002*U\u0005AA-\u001a9m_fLGO\u0003\u0002,Y\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002[\u0005\u00191m\\7\u0004\u0001M1\u0001\u0001\r\u001c;}\u0005\u0003\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0007CA\u001c9\u001b\u0005\u0011\u0013BA\u001d#\u0005U\u0001VM\u001c3j]\u001e$\u0016m]6SKB|7/\u001b;pef\u0004\"a\u000f\u001f\u000e\u0003\u0001J!!\u0010\u0011\u0003'A+g\u000eZ5oOR\u000b7o[:Rk\u0016\u0014\u0018.Z:\u0011\u0005mz\u0014B\u0001!!\u0005i\u0001VM\u001c3j]\u001e$\u0016m]6NKR\fG-\u0019;b#V,'/[3t!\t\u0011u)D\u0001D\u0015\t!U)A\u0003tY\u001a$$NC\u0001G\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001%D\u0005\u001daunZ4j]\u001e\fAB\u001b3cGR+W\u000e\u001d7bi\u0016,\u0012a\u0013\t\u0003\u0019Vk\u0011!\u0014\u0006\u0003\u001d>\u000bAaY8sK*\u0011\u0001+U\u0001\u0005U\u0012\u00147M\u0003\u0002S'\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001U\u0003\ry'oZ\u0005\u0003-6\u0013AB\u00133cGR+W\u000e\u001d7bi\u0016\fQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0013AC:dQ\u0016l\u0017-\u00138g_V\t!\f\u0005\u0002\\=6\tAL\u0003\u0002\";*\u0011a\nK\u0005\u0003?r\u0013!bU2iK6\f\u0017J\u001c4p\u0003-\u00198\r[3nC&sgm\u001c\u0011\u0002\rqJg.\u001b;?)\t\u0019\u0007\u0010\u0006\u0002eKB\u00111\b\u0001\u0005\u00061\u0016\u0001\u001dA\u0017\u0015\u0005K\u001e\f(\u000f\u0005\u0002i_6\t\u0011N\u0003\u0002kW\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00051l\u0017a\u00024bGR|'/\u001f\u0006\u0003]F\u000bQAY3b]NL!\u0001]5\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%A:\u0002\u00155\f\u0017N\\*dQ\u0016l\u0017\r\u000b\u0002fkB\u0011\u0001N^\u0005\u0003o&\u0014\u0011\"Q;u_^L'/\u001a3\t\u000b%+\u0001\u0019A&)\ta<\u0017O_\u0011\u0002w\u0006\u0001R.Y5o\u0015\u0012\u00147\rV3na2\fG/\u001a\u0015\u0003qV\fQ\u0001^1tWN$2a`A\u0010!\u0019\t\t!a\u0003\u0002\u00105\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003vi&d'BAA\u0005\u0003\u0011Q\u0017M^1\n\t\u00055\u00111\u0001\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0013\u0015DXmY;uS>t'bAA\rM\u0005\u0019\u0011\r]5\n\t\u0005u\u00111\u0003\u0002\u000e)\u0006\u001c8nV5uQ\ncwnY6\t\u000f\u0005\u0005b\u00011\u0001\u0002$\u0005aAn\\1e\rVdGn\u00159fGB\u0019\u0011'!\n\n\u0007\u0005\u001d\"GA\u0004C_>dW-\u00198\u0002\u001dM\u001c\u0007.\u001a3vY\u0016$G+Y:lgR\tq0A\u0006rk\u0016,X\r\u001a+bg.\u001cHCAA\u0019!\u0019\t\t!a\u0003\u00024A\u0019q'!\u000e\n\u0007\u0005]\"EA\u0006QK:$\u0017N\\4UCN\\\u0017\u0001\u0002;bg.$b!!\u0010\u0002D\u0005=\u0004#B\u0019\u0002@\u0005M\u0012bAA!e\t1q\n\u001d;j_:Dq!!\u0012\n\u0001\u0004\t9%\u0001\u0004uCN\\\u0017\n\u001a\t\u0005\u0003\u0013\nIG\u0004\u0003\u0002L\u0005\u0015d\u0002BA'\u0003GrA!a\u0014\u0002b9!\u0011\u0011KA0\u001d\u0011\t\u0019&!\u0018\u000f\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017/\u0003\u0019a$o\\8u}%\tQ&\u0003\u0002,Y%\u0011\u0011FK\u0005\u0003O!J!!\n\u0014\n\u0007\u0005\u001dD%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0014Q\u000e\u0002\u0007)\u0006\u001c8.\u00133\u000b\u0007\u0005\u001dD\u0005C\u0005\u0002\"%\u0001\n\u00111\u0001\u0002$\u0005qA/Y:lI\u0011,g-Y;mi\u0012\u0012TCAA;U\u0011\t\u0019#a\u001e,\u0005\u0005e\u0004\u0003BA>\u0003\u0007k!!! \u000b\t\u0005}\u0014\u0011Q\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u001b\u001a\n\t\u0005\u0015\u0015Q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0003:fC\u0012\u001cV/\\7bef$B!!\u0010\u0002\f\"9\u0011QI\u0006A\u0002\u0005\u001d\u0013\u0001\u0004:fC\u00124U\u000f\u001c7Ta\u0016\u001cG\u0003BA\u001f\u0003#Cq!!\u0012\r\u0001\u0004\t9%A\u0007u_B+g\u000eZ5oOR\u000b7o\u001b\u000b\u0005\u0003g\t9\nC\u0004\u0002\u001a6\u0001\r!a'\u0002\u0005I\u001c\b\u0003BAO\u0003Ck!!a(\u000b\u0007\u0005\n9!\u0003\u0003\u0002$\u0006}%!\u0003*fgVdGoU3u\u0003U\u0001XM\u001c3j]\u001e$\u0016m]6Ge>l')\u001b8bef$b\"a\r\u0002*\u0006m\u00161ZAp\u0003K\fI\u000fC\u0004\u0002F9\u0001\r!a+\u0011\t\u00055\u0016Q\u0017\b\u0005\u0003_\u000b\t\fE\u0002\u0002VIJ1!a-3\u0003\u0019\u0001&/\u001a3fM&!\u0011qWA]\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0017\u001a\t\u000f\u0005uf\u00021\u0001\u0002@\u0006iA/Y:l'B,7MQ=uKN\u0004R!MAa\u0003\u000bL1!a13\u0005\u0015\t%O]1z!\r\t\u0014qY\u0005\u0004\u0003\u0013\u0014$\u0001\u0002\"zi\u0016Dq!!4\u000f\u0001\u0004\ty-A\u0007tG\",G-\u001e7fI\u0012\u000bG/\u001a\t\u0005\u0003#\fY.\u0004\u0002\u0002T*!\u0011Q[Al\u0003\u0011!\u0018.\\3\u000b\u0007\u0005e7+\u0001\u0003k_\u0012\f\u0017\u0002BAo\u0003'\u0014\u0001\u0002R1uKRKW.\u001a\u0005\b\u0003Ct\u0001\u0019AAr\u000359xN]6fe\u0006#GM]3tgB)\u0011'a\u0010\u0002,\"9\u0011q\u001d\bA\u0002\u0005=\u0017AC9vKV,G\rR1uK\"I\u00111\u001e\b\u0011\u0002\u0003\u0007\u00111E\u0001\u000eSN\u001cVM\u001c;U_F+X-^3\u0002?A,g\u000eZ5oOR\u000b7o\u001b$s_6\u0014\u0015N\\1ss\u0012\"WMZ1vYR$c'A\u0003ti>\u0014X\r\u0006\u0004\u0002H\u0005M\u0018q \u0005\b\u0003k\u0004\u0002\u0019AA|\u0003\u0011\u0019\b/Z2\u0011\t\u0005e\u00181`\u0007\u0002I%\u0019\u0011Q \u0013\u0003#Q\u000b7o[*qK\u000eLg-[2bi&|g\u000eC\u0005\u0002bB\u0001\n\u00111\u0001\u0002d\u00061Q\u000f\u001d3bi\u0016$bA!\u0002\u0003\f\t5\u0001cA\u0019\u0003\b%\u0019!\u0011\u0002\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000b\n\u0002\u0019AA$\u0011\u001d\t)0\u0005a\u0001\u0003o\fAb\u001d9fGR{')\u001b8bef$B!a0\u0003\u0014!9\u0011Q\u001f\nA\u0002\u0005]\u0018AC:fe&\fG.\u001b>feV\u0011!\u0011\u0004\t\u0005\u00057\u0011\t$\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003\u0011Y'/_8\u000b\t\t\r\"QE\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\t\t\u001d\"\u0011F\u0001\u0005C.\\\u0017M\u0003\u0003\u0003,\t5\u0012!B1mi>|'B\u0001B\u0018\u0003\tIw.\u0003\u0003\u00034\tu!AE&ss>\f5n[1TKJL\u0017\r\\5{KJ\f1b\u00195b]\u001e,wj\u001e8feR1!Q\u0001B\u001d\u0005wAq!!\u0012\u0015\u0001\u0004\t9\u0005C\u0004\u0003>Q\u0001\r!a+\u0002\u00119,woT<oKJ\f\u0011#\\1sW\u0006\u001b8+\u001a8u)>\fV/Z;f)\u0011\u0011)Aa\u0011\t\u000f\u0005\u0015S\u00031\u0001\u0002,\u0006A1o\u00195fIVdW\r\u0006\u0004\u0003\u0006\t%#1\n\u0005\b\u0003\u000b2\u0002\u0019AA$\u0011\u001d\u0011iE\u0006a\u0001\u0003\u001f\fA\u0001Z1uK\u00061A-\u001a7fi\u0016$BA!\u0002\u0003T!9\u0011QI\fA\u0002\u0005\u001d\u0013\u0001\u00059sKB\f'/\u001a+p\u000b:\fX/Z;f)\u0011\u0011IFa\u0019\u0011\r\tm#qLA\b\u001b\t\u0011iFC\u0002\u0002\u0006IJAA!\u0019\u0003^\t\u0019AK]=\t\u000f\u0005\u0015\u0003\u00041\u0001\u0002H\u0005iQ\r\u001f;sC\u000e$H+Y:l\u0013\u0012$B!a\u0012\u0003j!9\u0011\u0011T\rA\u0002\u0005m\u0015\u0001F3yiJ\f7\r^,pe.,'/\u00113ee\u0016\u001c8\u000f\u0006\u0003\u0002d\n=\u0004bBAM5\u0001\u0007\u00111T\u0001\u0015Kb$(/Y2u'\u000eDW\rZ;mK\u0012$\u0015\r^3\u0015\t\u0005='Q\u000f\u0005\b\u00033[\u0002\u0019AAN\u0003a)\u0007\u0010\u001e:bGR$\u0016m]6Ta\u0016\u001c\u0017NZ5dCRLwN\u001c\u000b\u0005\u0003\u007f\u0013Y\bC\u0004\u0002\u001ar\u0001\r!a'\u0002)\u0015DHO]1di&\u001b8+\u001a8u)>\fV/Z;f)\u0011\t\u0019C!!\t\u000f\u0005eU\u00041\u0001\u0002\u001c\u0006\tR\r\u001f;sC\u000e$\u0018+^3vK\u0012$\u0015\r^3\u0015\t\u0005='q\u0011\u0005\b\u00033s\u0002\u0019AANQ\u0019\u0001!1R9\u0003\u001aB!!Q\u0012BK\u001b\t\u0011yIC\u0002k\u0005#S1Aa%R\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\t]%q\u0012\u0002\u000e)J\fgn]1di&|g.\u00197\"\u0005\tm\u0015AF7bS:$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:)\u0007\u0001\u0011y\n\u0005\u0003\u0003\"\n\u001dVB\u0001BR\u0015\r\u0011)+U\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002BU\u0005G\u0013\u0011bQ8na>tWM\u001c;")
public class SqlPendingTaskRepository
implements PendingTaskRepository,
PendingTasksQueries,
PendingTaskMetadataQueries,
Logging {
    private KryoAkkaSerializer serializer;
    private final JdbcTemplate jdbcTemplate;
    private final SchemaInfo schemaInfo;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String INSERT_METADATA;
    private String SELECT_METADATA;
    private String DELETE_METADATA;
    private String INSERT;
    private String UPDATE;
    private String UPDATE_OWNER;
    private String SELECT;
    private String SELECT_ALL;
    private String SELECT_ALL_SPECS;
    private String SELECT_SPEC;
    private String DELETE;
    private String UPDATE_SCHEDULED_DATE;
    private String UPDATE_SENT_TO_QUEUE_AND_QUEUED_DATE;
    private String SELECT_SCHEDULED;
    private String SELECT_QUEUED;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    public Option<String> store$default$2() {
        return PendingTaskRepository.store$default$2$((PendingTaskRepository)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String INSERT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 2) == 0) {
                this.INSERT_METADATA = PendingTaskMetadataQueries.INSERT_METADATA$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.INSERT_METADATA;
    }

    @Override
    public String INSERT_METADATA() {
        return (this.bitmap$0 & 2) == 0 ? this.INSERT_METADATA$lzycompute() : this.INSERT_METADATA;
    }

    private String SELECT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 4) == 0) {
                this.SELECT_METADATA = PendingTaskMetadataQueries.SELECT_METADATA$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.SELECT_METADATA;
    }

    @Override
    public String SELECT_METADATA() {
        return (this.bitmap$0 & 4) == 0 ? this.SELECT_METADATA$lzycompute() : this.SELECT_METADATA;
    }

    private String DELETE_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 8) == 0) {
                this.DELETE_METADATA = PendingTaskMetadataQueries.DELETE_METADATA$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.DELETE_METADATA;
    }

    @Override
    public String DELETE_METADATA() {
        return (this.bitmap$0 & 8) == 0 ? this.DELETE_METADATA$lzycompute() : this.DELETE_METADATA;
    }

    private String INSERT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.INSERT = PendingTasksQueries.INSERT$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (this.bitmap$0 & 0x10) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String UPDATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.UPDATE = PendingTasksQueries.UPDATE$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.UPDATE;
    }

    @Override
    public String UPDATE() {
        return (this.bitmap$0 & 0x20) == 0 ? this.UPDATE$lzycompute() : this.UPDATE;
    }

    private String UPDATE_OWNER$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.UPDATE_OWNER = PendingTasksQueries.UPDATE_OWNER$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.UPDATE_OWNER;
    }

    @Override
    public String UPDATE_OWNER() {
        return (this.bitmap$0 & 0x40) == 0 ? this.UPDATE_OWNER$lzycompute() : this.UPDATE_OWNER;
    }

    private String SELECT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.SELECT = PendingTasksQueries.SELECT$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.SELECT;
    }

    @Override
    public String SELECT() {
        return (this.bitmap$0 & 0x80) == 0 ? this.SELECT$lzycompute() : this.SELECT;
    }

    private String SELECT_ALL$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.SELECT_ALL = PendingTasksQueries.SELECT_ALL$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.SELECT_ALL;
    }

    @Override
    public String SELECT_ALL() {
        return (this.bitmap$0 & 0x100) == 0 ? this.SELECT_ALL$lzycompute() : this.SELECT_ALL;
    }

    private String SELECT_ALL_SPECS$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.SELECT_ALL_SPECS = PendingTasksQueries.SELECT_ALL_SPECS$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.SELECT_ALL_SPECS;
    }

    @Override
    public String SELECT_ALL_SPECS() {
        return (this.bitmap$0 & 0x200) == 0 ? this.SELECT_ALL_SPECS$lzycompute() : this.SELECT_ALL_SPECS;
    }

    private String SELECT_SPEC$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.SELECT_SPEC = PendingTasksQueries.SELECT_SPEC$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.SELECT_SPEC;
    }

    @Override
    public String SELECT_SPEC() {
        return (this.bitmap$0 & 0x400) == 0 ? this.SELECT_SPEC$lzycompute() : this.SELECT_SPEC;
    }

    private String DELETE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.DELETE = PendingTasksQueries.DELETE$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (this.bitmap$0 & 0x800) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String UPDATE_SCHEDULED_DATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.UPDATE_SCHEDULED_DATE = PendingTasksQueries.UPDATE_SCHEDULED_DATE$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.UPDATE_SCHEDULED_DATE;
    }

    @Override
    public String UPDATE_SCHEDULED_DATE() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.UPDATE_SCHEDULED_DATE$lzycompute() : this.UPDATE_SCHEDULED_DATE;
    }

    private String UPDATE_SENT_TO_QUEUE_AND_QUEUED_DATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.UPDATE_SENT_TO_QUEUE_AND_QUEUED_DATE = PendingTasksQueries.UPDATE_SENT_TO_QUEUE_AND_QUEUED_DATE$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.UPDATE_SENT_TO_QUEUE_AND_QUEUED_DATE;
    }

    @Override
    public String UPDATE_SENT_TO_QUEUE_AND_QUEUED_DATE() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.UPDATE_SENT_TO_QUEUE_AND_QUEUED_DATE$lzycompute() : this.UPDATE_SENT_TO_QUEUE_AND_QUEUED_DATE;
    }

    private String SELECT_SCHEDULED$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.SELECT_SCHEDULED = PendingTasksQueries.SELECT_SCHEDULED$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.SELECT_SCHEDULED;
    }

    @Override
    public String SELECT_SCHEDULED() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.SELECT_SCHEDULED$lzycompute() : this.SELECT_SCHEDULED;
    }

    private String SELECT_QUEUED$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.SELECT_QUEUED = PendingTasksQueries.SELECT_QUEUED$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.SELECT_QUEUED;
    }

    @Override
    public String SELECT_QUEUED() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.SELECT_QUEUED$lzycompute() : this.SELECT_QUEUED;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SchemaInfo schemaInfo() {
        return this.schemaInfo;
    }

    public java.util.List<TaskWithBlock> tasks(boolean loadFullSpec) {
        List tasks = loadFullSpec ? CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(this.SELECT_ALL_SPECS(), (rs, x$1) -> this.com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(rs))).asScala().toList() : ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().queryForList(this.SELECT_ALL())).asScala().groupBy((Function1 & Serializable)x$2 -> (String)x$2.get(PendingTaskSchema$.MODULE$.task_id().name())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer list = (Buffer)tuple2._2();
            java.util.Map task = (java.util.Map)list.headOption().getOrElse((Function0 & Serializable)() -> {
                throw new NoSuchElementException("No pending task");
            });
            String taskId = (String)task.get(PendingTaskSchema$.MODULE$.task_id().name());
            String taskDescription = (String)task.get(PendingTaskSchema$.MODULE$.task_description().name());
            String owner = (String)task.get(PendingTaskSchema$.MODULE$.task_owner().name());
            String workerAddress = (String)task.get(PendingTaskSchema$.MODULE$.worker_address().name());
            DateTime scheduledDate = (DateTime)Option$.MODULE$.apply(task.get(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable)date -> com.xebialabs.deployit.core.sql.package$.MODULE$.mapDateTime(date)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Boolean isSentToQueue = TypeConversions$.MODULE$.enforceBoolean(task.get(PendingTaskSchema$.MODULE$.is_sent_to_queue().name()));
            DateTime queuedDate = (DateTime)Option$.MODULE$.apply(task.get(PendingTaskSchema$.MODULE$.queued_date().name())).map((Function1 & Serializable)date -> com.xebialabs.deployit.core.sql.package$.MODULE$.mapDateTime(date)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            java.util.Map metadata = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)list.map((Function1 & Serializable)item -> {
                String key = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_key().name());
                String value = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_value().name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, metadata, scheduledDate, (Option)None$.MODULE$, Option$.MODULE$.apply((Object)workerAddress), queuedDate, Predef$.MODULE$.Boolean2boolean(isSentToQueue));
            return pendingTask;
        })).toList();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)tasks).asJava();
    }

    public java.util.List<TaskWithBlock> scheduledTasks() {
        return this.jdbcTemplate().query(this.SELECT_SCHEDULED(), (RowMapper)new RowMapper<TaskWithBlock>(this){
            private final /* synthetic */ SqlPendingTaskRepository $outer;

            public TaskWithBlock mapRow(ResultSet rs, int rowNum) {
                return this.$outer.com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(rs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public java.util.List<PendingTask> queuedTasks() {
        return this.jdbcTemplate().query(this.SELECT_QUEUED(), (RowMapper)new RowMapper<PendingTask>(this){
            private final /* synthetic */ SqlPendingTaskRepository $outer;

            public PendingTask mapRow(ResultSet rs, int rowNum) {
                return this.$outer.com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(rs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<PendingTask> task(String taskId, boolean loadFullSpec) {
        return loadFullSpec ? this.readFullSpec(taskId) : this.readSummary(taskId);
    }

    public boolean task$default$2() {
        return false;
    }

    private Option<PendingTask> readSummary(String taskId) {
        None$ none$;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(30).append("Reading the summary of task [").append(taskId).append("]").toString());
        try {
            none$ = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT(), (rs, x$3) -> {
                String description = rs.getString(PendingTaskSchema$.MODULE$.task_description().name());
                String owner = rs.getString(PendingTaskSchema$.MODULE$.task_owner().name());
                Option<String> workerAddress = this.extractWorkerAddress(rs);
                DateTime scheduledDate = this.extractScheduledDate(rs);
                boolean isSentToQueue = this.extractIsSentToQueue(rs);
                DateTime queuedDate = this.extractQueuedDate(rs);
                return new Tuple6((Object)description, (Object)owner, (Object)scheduledDate, workerAddress, (Object)queuedDate, (Object)BoxesRunTime.boxToBoolean((boolean)isSentToQueue));
            }, new Object[]{taskId})).map((Function1 & Serializable)x0$1 -> {
                Tuple6 tuple6 = x0$1;
                if (tuple6 == null) {
                    throw new MatchError((Object)tuple6);
                }
                String taskDescription = (String)tuple6._1();
                String owner = (String)tuple6._2();
                DateTime scheduledDate = (DateTime)tuple6._3();
                Option workerAddress = (Option)tuple6._4();
                DateTime queuedDate = (DateTime)tuple6._5();
                boolean isSentToQueue = BoxesRunTime.unboxToBoolean((Object)tuple6._6());
                HashMap metadata = (HashMap)this.jdbcTemplate().query(this.SELECT_METADATA(), rs -> {
                    void var1_1;
                    HashMap<String, String> map = new HashMap<String, String>();
                    while (rs.next()) {
                        map.put(rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_key().name()), rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_value().name()));
                    }
                    return var1_1;
                }, new Object[]{taskId});
                PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, (java.util.Map)metadata, scheduledDate, (Option)None$.MODULE$, workerAddress, queuedDate, isSentToQueue);
                return pendingTask;
            });
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<PendingTask> readFullSpec(String taskId) {
        Option option;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(41).append("Reading the full specification of task [").append(taskId).append("]").toString());
        try {
            option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT_SPEC(), (rs, x$4) -> this.com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(rs), new Object[]{taskId}));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            option = None$.MODULE$;
        }
        return option;
    }

    public PendingTask com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(ResultSet rs) {
        return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), this.extractScheduledDate(rs), this.extractWorkerAddress(rs), this.extractQueuedDate(rs), this.extractIsSentToQueue(rs));
    }

    private PendingTask pendingTaskFromBinary(String taskId, byte[] taskSpecBytes, DateTime scheduledDate, Option<String> workerAddress, DateTime queuedDate, boolean isSentToQueue) {
        Object object = this.serializer().fromBinary(taskSpecBytes);
        if (!(object instanceof TaskSpecification)) {
            throw new RuntimeException(new StringBuilder(42).append("Could not deserialize TaskSpecification [").append(taskId).append("]").toString());
        }
        TaskSpecification taskSpecification = (TaskSpecification)object;
        PendingTask pt = new PendingTask(taskId, taskSpecification.getDescription(), taskSpecification.getOwner().getName(), taskSpecification.getMetadata(), scheduledDate, (Option)new Some((Object)taskSpecification), workerAddress, queuedDate, isSentToQueue);
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(42).append("Pending task from binary has been created ").append(pt).toString());
        PendingTask pendingTask = pt;
        return pendingTask;
    }

    private boolean pendingTaskFromBinary$default$6() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String store(TaskSpecification spec, Option<String> workerAddress) {
        void var3_3;
        String taskId = spec.getId();
        byte[] bytes = this.specToBinary(spec);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{taskId, spec.getDescription(), spec.getOwner().getName(), bytes, workerAddress.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())});
        spec.getMetadata().forEach((k, v) -> this.jdbcTemplate().update(this.INSERT_METADATA(), new Object[]{taskId, k, v}));
        return var3_3;
    }

    public void update(String taskId, TaskSpecification spec) {
        byte[] bytes = this.specToBinary(spec);
        try {
            this.jdbcTemplate().update(this.UPDATE(), new Object[]{bytes, taskId});
        }
        catch (Exception exception) {
            throw new TaskNotFoundException("pending tasks", taskId);
        }
    }

    private byte[] specToBinary(TaskSpecification spec) {
        byte[] value;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.serializer().toBinary((Object)spec));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().error((Function0 & Serializable)() -> exception.getMessage(), (Function0 & Serializable)() -> exception);
                throw exception;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        byte[] byArray = value = (byte[])success.value();
        return byArray;
    }

    private KryoAkkaSerializer serializer$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 1) == 0) {
                this.serializer = (KryoAkkaSerializer)((Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)((ExtendedActorSystem)TaskActorSystem$.MODULE$.actorSystem()))).serializerFor(Serializable.class);
                this.bitmap$0 |= 1;
            }
        }
        return this.serializer;
    }

    private KryoAkkaSerializer serializer() {
        return (this.bitmap$0 & 1) == 0 ? this.serializer$lzycompute() : this.serializer;
    }

    public void changeOwner(String taskId, String newOwner) {
        this.jdbcTemplate().update(this.UPDATE_OWNER(), new Object[]{newOwner, taskId});
    }

    public void markAsSentToQueue(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Marking task [").append(taskId).append("] as sent to the queue").toString());
        this.jdbcTemplate().update(con -> {
            void var3_3;
            PreparedStatement ps = con.prepareStatement(this.UPDATE_SENT_TO_QUEUE_AND_QUEUED_DATE());
            ps.setBoolean(1, Predef$.MODULE$.Boolean2boolean(Boolean.TRUE));
            com.xebialabs.deployit.core.sql.package$.MODULE$.setTimestamp(ps, 2, DateTime.now());
            Setter$.MODULE$.setString(ps, 3, taskId);
            return var3_3;
        });
    }

    public void schedule(String taskId, DateTime date) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Task [").append(taskId).append("] has been scheduled").toString());
        this.jdbcTemplate().update(this.UPDATE_SCHEDULED_DATE(), new Object[]{com.xebialabs.deployit.core.sql.package$.MODULE$.toTimestamp(date), taskId});
    }

    public void delete(String taskId) {
        this.jdbcTemplate().update(this.DELETE_METADATA(), new Object[]{taskId});
        this.jdbcTemplate().update(this.DELETE(), new Object[]{taskId});
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(44).append("Pending task ").append(taskId).append(" has been deleted from database").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<TaskWithBlock> prepareToEnqueue(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Preparing task [taskId] to enqueue");
        SimpleSelectBuilder q = this.schemaInfo().sqlDialect().lockSelectBuilder(PendingTaskSchema$.MODULE$.tableName(), this.schemaInfo()).select((Selectable)PendingTaskSchema$.MODULE$.task_id()).select((Selectable)PendingTaskSchema$.MODULE$.scheduled_date()).select((Selectable)PendingTaskSchema$.MODULE$.task_specification()).select((Selectable)PendingTaskSchema$.MODULE$.worker_address()).select((Selectable)PendingTaskSchema$.MODULE$.queued_date()).select((Selectable)PendingTaskSchema$.MODULE$.is_sent_to_queue()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)PendingTaskSchema$.MODULE$.task_id(), taskId));
        boolean bl = false;
        Some some = null;
        Option option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(q.query(), (rs, x$5) -> {
            DateTime scheduledDate = this.extractScheduledDate(rs);
            Option<String> workerAddress = this.extractWorkerAddress(rs);
            DateTime queuedDate = this.extractQueuedDate(rs);
            return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), scheduledDate, workerAddress, queuedDate, this.extractIsSentToQueue(rs));
        }, new Object[]{taskId}));
        if (None$.MODULE$.equals(option)) {
            return new Failure((Throwable)new RuntimeException(new StringBuilder(21).append("Task [").append(taskId).append("] was not found").toString()));
        }
        if (option instanceof Some) {
            PendingTask pendingTask;
            bl = true;
            some = (Some)option;
            TaskWithBlock task = (TaskWithBlock)some.value();
            if (task instanceof PendingTask && (pendingTask = (PendingTask)task).isSentToQueue()) {
                return new Failure((Throwable)new RuntimeException(new StringBuilder(32).append("Task [").append(taskId).append("] is already sent to queue").toString()));
            }
        }
        if (!bl) throw new MatchError(option);
        TaskWithBlock task = (TaskWithBlock)some.value();
        return new Success((Object)task);
    }

    private String extractTaskId(ResultSet rs) {
        return rs.getString(PendingTaskSchema$.MODULE$.task_id().name());
    }

    private Option<String> extractWorkerAddress(ResultSet rs) {
        return Option$.MODULE$.apply((Object)rs.getString(PendingTaskSchema$.MODULE$.worker_address().name()));
    }

    private DateTime extractScheduledDate(ResultSet rs) {
        return (DateTime)Option$.MODULE$.apply((Object)rs.getTimestamp(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime(t)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private byte[] extractTaskSpecification(ResultSet rs) {
        return rs.getBytes(PendingTaskSchema$.MODULE$.task_specification().name());
    }

    private boolean extractIsSentToQueue(ResultSet rs) {
        return rs.getBoolean(PendingTaskSchema$.MODULE$.is_sent_to_queue().name());
    }

    private DateTime extractQueuedDate(ResultSet rs) {
        return (DateTime)Option$.MODULE$.apply((Object)rs.getTimestamp(PendingTaskSchema$.MODULE$.queued_date().name())).map((Function1 & Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime(t)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public SqlPendingTaskRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSchema") SchemaInfo schemaInfo) {
        this.jdbcTemplate = jdbcTemplate;
        this.schemaInfo = schemaInfo;
        Queries.$init$((Queries)this);
        PendingTasksQueries.$init$(this);
        PendingTaskMetadataQueries.$init$(this);
        Logging.$init$((Logging)this);
    }
}

