package com.xebialabs.deployit.task.archive.sql

import java.sql.ResultSet
import java.util.Spliterator
import java.util.function._
import java.util.stream.{Stream, StreamSupport}

import org.springframework.jdbc.support.JdbcUtils

object StreamingResultSet {
  def from(rs: ResultSet): Stream[ResultSet] =
    StreamSupport.stream(new StreamingResultSet(rs), false).onClose(() => {
      val s = rs.getStatement
      JdbcUtils.closeResultSet(rs)
      JdbcUtils.closeStatement(s)
    })
}

private class StreamingResultSet(rs: ResultSet) extends Spliterator[ResultSet] {
  override def characteristics() = Spliterator.ORDERED

  override def trySplit() = null

  override def estimateSize() = Long.MaxValue

  override def tryAdvance(action: Consumer[_ >: ResultSet]) = {
    if (rs.next()) {
      action.accept(rs)
      true
    } else {
      rs.close()
      false
    }
  }
}