package com.xebialabs.deployit.task.archive.sql

import com.xebialabs.deployit.core.sql.{Queries, SchemaInfo, toCalendar}
import com.xebialabs.deployit.task.archive.TaskMessage
import org.joda.time.DateTime
import org.springframework.jdbc.core.JdbcTemplate

class DefaultTaskArchiver(taskMessage: TaskMessage)
                         (override implicit val schemaInfo: SchemaInfo) extends TaskArchiver with DefaultTaskArchiverQueries {

  override def store(jdbcTemplate: JdbcTemplate): Unit = {
    archiveDetails(jdbcTemplate)
    jdbcTemplate.update(
      INSERT_UNKNOWN,
      taskMessage.taskId,
      toCalendar(taskMessage.startDate),
      toCalendar(DateTime.now())
    )
  }

  protected def archiveDetails(jdbcTemplate: JdbcTemplate): Unit = {
    jdbcTemplate.update(
      INSERT,
      taskMessage.taskId,
      taskMessage.archiveDetails.taskKind,
      taskMessage.archiveDetails.workerName.orNull,
      taskMessage.archiveDetails.taskDetails
    )
  }
}

trait DefaultTaskArchiverQueries extends Queries {

  lazy val INSERT_UNKNOWN: String = {
    import com.xebialabs.deployit.task.archive.sql.schema.ArchivedUnknownTasks._
    sqlb"insert into $tableName ($task_id, $start_date, $archived_date) values (?, ?, ?)"
  }

  lazy val INSERT: String = {
    import com.xebialabs.deployit.task.archive.sql.schema.ArchivedTasks._
    sqlb"insert into $tableName ($task_id, $task_kind, $worker_name, $task_details) values (?, ?, ?, ?)"
  }
}
