package com.xebialabs.deployit.task.archive.sql.reports

import com.xebialabs.deployit.core.sql._
import org.joda.time.DateTime

class SqlDeploymentTaskAnalyticsWithPermissionsQuery(override val begin: DateTime, override val end: DateTime, references: List[String])
                                                    (override implicit val schemaInfo: SchemaInfo)
  extends SqlDeploymentTaskAnalyticsQuery(begin, end) {

  override protected def createSelectBuilder: SelectBuilder = new WrappedJoinBuilder(createJoinBuilder)

  protected def createJoinBuilder: JoinBuilder = {
    import com.xebialabs.deployit.task.archive.sql._
    val selectBuilder = super.createSelectBuilder
    archivedDeploymentTaskColumns.foreach(column => selectBuilder.select(column))
    new ArchiveTaskSelectWithPermissionQuery(references)
      .deploymentTaskQuery(selectBuilder.distinct())
  }

}
