package com.xebialabs.deployit.task.archive.sql

// The Standard Deviation is a measure of how spread out numbers are. Hereby utility to compute dependecies as:
// arithmetic mean, sample standard deviation, bins/buckets/cluster limits.
// Online calculator for acuracy check: https://www.mathsisfun.com/data/standard-deviation-calculator.html
object StandardDeviationBucketsComputeUtility {

  def bins(mean: Double, stddev: Double): List[(Option[Int], Option[Int])] =
    (None :: Range.inclusive(-2, 2).map { i => mean + i * stddev }.filter( _> 0).map( d => Some(d.toInt)).toList ::: None :: Nil)
      .sliding(2).map { case List(a,b) => (a,b) }.toList

}