package com.xebialabs.deployit.task.archive.sql

import com.xebialabs.deployit.core.sql.{SqlCondition => cond, _}
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks.Applications
import com.xebialabs.deployit.task.archive.sql.schema.{ArchivedControlTasks, ArchivedDeploymentTasks}

class ArchiveTaskSelectWithPermissionQuery(val references: List[String])(implicit val schemaInfo: SchemaInfo) {

  import ArchiveTaskSelectWithPermissionQuery._

  def applicationTaskQuery: SelectBuilder = new SelectBuilder(ArchivedDeploymentTasks.Applications.tableName).as(aliasArchivedApplications)

  def deploymentTaskQuery(baseTaskSelectBuilder: SelectBuilder, applicationSelectBuilder: SelectBuilder = applicationTaskQuery): JoinBuilder = {
    if(references.nonEmpty)
      baseTaskSelectBuilder.as(aliasArchivedDeploymentTasks).where(
        cond.and(Seq(
          cond.in(ArchivedDeploymentTasks.environment_dir_ref.tableAlias(aliasArchivedDeploymentTasks), references),
          cond.in(Applications.application_dir_ref.tableAlias(aliasArchivedApplications), references)
        ))
      )
    else
      baseTaskSelectBuilder.as(aliasArchivedDeploymentTasks).where(
        cond.and(Seq(
          cond.equals(ArchivedDeploymentTasks.environment_dir_ref.tableAlias(aliasArchivedDeploymentTasks), "global-non-match"),
          cond.equals(Applications.application_dir_ref.tableAlias(aliasArchivedApplications), "global-non-match")
        ))
      )

    val builder = new JoinBuilder(baseTaskSelectBuilder).join(
      applicationSelectBuilder,
      cond.equals(
        ArchivedDeploymentTasks.Applications.task_id.tableAlias(aliasArchivedApplications),
        ArchivedDeploymentTasks.task_id.tableAlias(aliasArchivedDeploymentTasks))
    )
    builder
  }

  def controlTaskQuery(baseTaskSelectBuilder: SelectBuilder): AbstractQueryBuilder = {
    if (references.nonEmpty)
      baseTaskSelectBuilder.where(cond.in(ArchivedControlTasks.target_dir_ref, references))
    else
      baseTaskSelectBuilder.where(cond.equals(ArchivedControlTasks.target_dir_ref, "global-non-match"))
  }
}

object ArchiveTaskSelectWithPermissionQuery {
  val aliasControlTasks = "act"
  val aliasArchivedDeploymentTasks = "adt"
  val aliasArchivedApplications = "adtapp"

  val aliasArchivedDeploymentTaskPermissions = "adtperm"
  val aliasArchivedApplicationPermissions = "adtappperm"
  val aliasArchivedDeploymentTaskRoles = "adtrole"
  val aliasArchivedApplicationRoles = "adtapprole"

  val aliasControlTaskPermissions = "actperm"
  val aliasControlTaskRoles = "acttrole"
}
