package com.xebialabs.deployit.task.archive.sql.reports

import com.xebialabs.deployit.core.sql._
import com.xebialabs.deployit.security.RolesPermissionsPair
import org.joda.time.DateTime

import scala.jdk.CollectionConverters._

class SqlDeploymentTaskAnalyticsWithPermissionsQuery(override val begin: DateTime, override val end: DateTime,
                                                     securityData: RolesPermissionsPair)
                                                    (override implicit val schemaInfo: SchemaInfo)
  extends SqlDeploymentTaskAnalyticsQuery(begin, end) {

  override protected def createSelectBuilder: SelectBuilder = new WrappedJoinBuilder(createJoinBuilder)

  protected def createJoinBuilder: JoinBuilder = {
    import com.xebialabs.deployit.task.archive.sql._
    val selectBuilder = super.createSelectBuilder
    archivedDeploymentTaskColumns.foreach(column => selectBuilder.select(column))
    new ArchiveTaskSelectWithPermissionQuery(securityData.getRoles.asScala.toList,
      securityData.getPermissions.asScala.toList)
      .deploymentTaskQuery(selectBuilder)
  }

}
