package com.xebialabs.deployit.task.archive.sql

import com.xebialabs.deployit.core.sql.{Queries, SchemaInfo, toCalendar}
import com.xebialabs.deployit.task.archive.ControlTaskMessage
import org.springframework.jdbc.core.JdbcTemplate

class ControlTaskArchiver(controlTaskMessage: ControlTaskMessage)(override implicit val schemaInfo: SchemaInfo)
  extends DefaultTaskArchiver(controlTaskMessage)  with ControlTaskArchiverQueries {

  override def store(jdbcTemplate: JdbcTemplate): Unit = {
    archiveDetails(jdbcTemplate)
    jdbcTemplate.update(
      INSERT_CONTROL,
      controlTaskMessage.taskId,
      controlTaskMessage.taskName,
      controlTaskMessage.targetCi,
      controlTaskMessage.targetInternalId.asInstanceOf[Object],
      controlTaskMessage.targetSecuredId.map(_.asInstanceOf[Object]).orNull,
      controlTaskMessage.targetDirectoryReference,
      controlTaskMessage.owner,
      controlTaskMessage.description,
      controlTaskMessage.state,
      controlTaskMessage.failureCount,
      toCalendar(controlTaskMessage.startDate),
      toCalendar(controlTaskMessage.completionDate),
      controlTaskMessage.archiveDetails.workerName.orNull
    )
  }
}

trait ControlTaskArchiverQueries extends Queries {

  lazy val INSERT_CONTROL: String = {
    import com.xebialabs.deployit.task.archive.sql.schema.ArchivedControlTasks._
    sqlb"insert into $tableName ($task_id, $control_task_name, $target_ci, $target_internal_id, " +
      sqlb"$target_secured_ci, $target_dir_ref, $owner, $description, $status, $failure_count, $start_date, $end_date, $worker_name) " +
      sqlb"values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
  }

}
