package com.xebialabs.deployit.security.repository

import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}
import com.xebialabs.deployit.security.model.XldUserToken

import java.util
import java.util.Date

trait XldUserTokenRepository {
  def listUserTokenByUserName(username: String, paging: Paging,  order: Ordering, tokenNote: String): util.List[XldUserToken]
  def listUserTokenByTokenHash(tokenHash: String): util.List[XldUserToken]
  def createUserToken(username: String, createdDate: Date, expiryDate: Date, tokenNote: String, tokenHash: String): Int
  def deleteTokenByUsername(username: String): Unit
  def deleteTokenByCiIdAndUsername(username: String, ciId: Integer): Unit
  def updateLastUsedDate(ciId: Int, lastUsedDate: Date): Int
  def listTokensExpiringInDays(days: Int, paging: Paging): util.List[XldUserToken]
  def updateTokenExpiredNotified(ciId: Int, notifiedDate: Date, isNotified: Boolean): Unit
  def countUserTokens(username: String): Int
}
