package com.xebialabs.deployit.security.service.impl

import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}
import com.xebialabs.deployit.security.model.{Tokens, XldUserToken}
import com.xebialabs.deployit.security.repository.XldUserTokenRepository
import com.xebialabs.deployit.security.service.UserTokenService
import com.xebialabs.deployit.core.util.TokenGenerator
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.Date


@Service
class UserTokenServiceImpl(@Autowired xldUserTokenRepository: XldUserTokenRepository) extends UserTokenService{

  override def listUserTokenByUserName(username: String, paging: Paging, order: Ordering, tokenNote: String): XldUserToken = {
    val tokenList = xldUserTokenRepository.listUserTokenByUserName(username, paging, order, tokenNote)
    if (tokenList.isEmpty){
      new XldUserToken(username, List.empty)
    } else {
      tokenList.get(0)
    }
  }

  override def createUserToken(username: String, tokenNote: String, expiryDate: Date): XldUserToken = {
    val token: String = TokenGenerator.generate("dpa_")
    val ciId = xldUserTokenRepository.createUserToken(username, new Date(), expiryDate, tokenNote, TokenGenerator.hash(token))
    val userToken: Tokens = Tokens(new Date(), null, expiryDate, tokenNote, token, ciId, false, null)
    new XldUserToken(username, List(userToken))
  }

  override def deleteUserToken(username: String, ciId: Integer): Unit = {
    xldUserTokenRepository.deleteTokenByCiIdAndUsername(username, ciId)
  }

  override def findByUserToken(tokenHash: String): XldUserToken = {
    Option(xldUserTokenRepository.listUserTokenByTokenHash(tokenHash))
      .filter(!_.isEmpty)
      .map(_.get(0))
      .orNull
  }

  override def updateLastUsedDate(ciId: Int, lastUsedDate: Date): Int = xldUserTokenRepository.updateLastUsedDate(ciId: Int, lastUsedDate)

  override def listTokensExpiringInDays(days: Int, paging: Paging): java.util.List[XldUserToken] = {
    xldUserTokenRepository.listTokensExpiringInDays(days, paging)
  }

  override def updateTokenExpiredNotified(ciId: Int, notifiedDate: Date, isNotified: Boolean): Unit = {
    xldUserTokenRepository.updateTokenExpiredNotified(ciId, notifiedDate, isNotified)
  }
}
