package com.xebialabs.deployit.security.service

import java.util.Date
import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}
import com.xebialabs.deployit.security.model.XldUserToken

trait UserTokenService {
  def createUserToken(username: String, tokenNote: String, expiryDate: Date): XldUserToken
  def listUserTokenByUserName(username: String, paging: Paging, order: Ordering, tokenNote: String): XldUserToken
  def deleteUserToken(username: String, ciId: Integer): Unit
  def findByUserToken(tokenHash: String): XldUserToken
  def updateLastUsedDate(ciId: Int, lastUsedDate: Date): Int
}
