package com.xebialabs.deployit.security.repository

import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}
import com.xebialabs.deployit.security.model.XldUserToken

import java.util
import java.util.Date

trait XldUserTokenRespository {
  def listUserTokenByUserName(username: String, paging: Paging,  order: Ordering, tokenNote: String): util.List[XldUserToken]
  def createUserToken(username: String, createdDate: Date, expiryDate: Date, tokenNote: String, tokenHash: String): Int
  def deleteTokenByUsername(username: String): Unit
  def deleteTokenByCiIdAndUsername(username: String, ciId: Integer): Unit
}
