package com.xebialabs.deployit.security.service.impl

import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}
import com.xebialabs.deployit.security.model.{Tokens, XldUserToken}
import com.xebialabs.deployit.security.repository.XldUserTokenRespository
import com.xebialabs.deployit.security.service.UserTokenService
import com.xebialabs.deployit.core.util.TokenGenerator
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.Date
import java.time.{LocalTime, ZoneId, ZoneOffset}


@Service
class UserTokenServiceImpl(@Autowired xldUserTokenRepository: XldUserTokenRespository) extends UserTokenService{

  override def listUserTokenByUserName(username: String, paging: Paging,  order: Ordering, tokenNote: String): XldUserToken = {
    val tokenList = xldUserTokenRepository.listUserTokenByUserName(username, paging, order, tokenNote)
    if (tokenList.isEmpty){
      new XldUserToken(username, List.empty)
    } else {
      tokenList.get(0)
    }
  }

  override def createUserToken(username: String, tokenNote: String, expiryDate: Date): XldUserToken = {
    val token: String = TokenGenerator.generate("dpa_")
    // set expiry date as end of day
    val revisedExpiryDate: Date = if (null == expiryDate) {
     expiryDate
    } else {
      val localExpiryDate = expiryDate.toInstant.atZone(ZoneId.of("UTC")).toLocalDate.atTime(LocalTime.MAX)
      Date.from(localExpiryDate.toInstant(ZoneOffset.MAX))
    }
    val ciId = xldUserTokenRepository.createUserToken(username, new Date(), revisedExpiryDate, tokenNote, TokenGenerator.hash(token))
    val userToken: Tokens = Tokens(new Date(), null, revisedExpiryDate, tokenNote, token, ciId)
    new XldUserToken(username, List(userToken))
  }

  override def deleteUserToken(username: String, ciId: Integer): Unit = {
    xldUserTokenRepository.deleteTokenByCiIdAndUsername(username, ciId)
  }
}
