package com.xebialabs.deployit.security

import ai.digital.deploy.permissions.client.util.SortOrder
import com.xebialabs.deployit.engine.api.dto.Ordering

import scala.jdk.CollectionConverters._

package object client {
  private[client] def getSortOrder(order: Ordering): SortOrder =
    if(order == null || order.isAscending) {
      SortOrder.ASC
    }
    else {
      SortOrder.DESC
    }

  implicit class MapExtensions[K, V](val value: Map[K, V]) {
    def asJavaMutable(): java.util.Map[K, V] = new java.util.HashMap[K, V](value.asJava)
  }

  implicit class SetExtensions[V](val value: Set[V]) {
    def asJavaMutable(): java.util.Set[V] = new java.util.HashSet[V](value.asJava)
  }

  implicit class ListExtensions[V](val value: Seq[V]) {
    def asJavaMutable(): java.util.List[V] = new java.util.ArrayList[V](value.asJava)
  }
}
