/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.service.impl;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.model.XldUserProfile;
import com.xebialabs.deployit.security.model.XldUserProfile$;
import com.xebialabs.deployit.security.repository.XldUserProfileRepository;
import com.xebialabs.deployit.security.service.UserProfileService;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001\u0002\b\u0010\u0001qA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A1\t\u0001B\u0001B\u0003%A\tC\u0003M\u0001\u0011\u0005Q\nC\u0003W\u0001\u0011\u0005s\u000bC\u0003W\u0001\u0011\u0005\u0003\u000fC\u0003s\u0001\u0011\u00053\u000fC\u0003{\u0001\u0011\u00053\u0010C\u0003\u007f\u0001\u0011%q\u0010C\u0004\u0002\u000e\u0001!\t%a\u0004\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA#\u0001\u0011\u0005\u0013q\t\u0002\u0017+N,'\u000f\u0015:pM&dWmU3sm&\u001cW-S7qY*\u0011\u0001#E\u0001\u0005S6\u0004HN\u0003\u0002\u0013'\u000591/\u001a:wS\u000e,'B\u0001\u000b\u0016\u0003!\u0019XmY;sSRL(B\u0001\f\u0018\u0003!!W\r\u001d7ps&$(B\u0001\r\u001a\u0003%AXMY5bY\u0006\u00147OC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011*S\"A\t\n\u0005\u0019\n\"AE+tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\f\u0001\u0004\u001f7e+N,'\u000f\u0015:pM&dWMU3q_NLGo\u001c:z!\tIC&D\u0001+\u0015\tY3#\u0001\u0006sKB|7/\u001b;pefL!!\f\u0016\u00031acG-V:feB\u0013xNZ5mKJ+\u0007o\\:ji>\u0014\u0018\u0010\u000b\u0002\u0002_A\u0011\u0001gO\u0007\u0002c)\u0011!gM\u0001\u000bC:tw\u000e^1uS>t'B\u0001\u001b6\u0003\u001d1\u0017m\u0019;pefT!AN\u001c\u0002\u000b\t,\u0017M\\:\u000b\u0005aJ\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003i\n1a\u001c:h\u0013\ta\u0014GA\u0005BkR|w/\u001b:fI\u0006Y!o\u001c7f'\u0016\u0014h/[2f!\ty\u0004)D\u0001\u0014\u0013\t\t5CA\u0006S_2,7+\u001a:wS\u000e,\u0007F\u0001\u00020\u00039a\u0017nY3og\u0016\u001cVM\u001d<jG\u0016\u0004\"!R%\u000e\u0003\u0019S!AE$\u000b\u0005!;\u0012a\u00027jG\u0016t7/Z\u0005\u0003\u0015\u001a\u0013a\u0002T5dK:\u001cXmU3sm&\u001cW\r\u000b\u0002\u0004_\u00051A(\u001b8jiz\"BA\u0014)S)B\u0011q\nA\u0007\u0002\u001f!)q\u0005\u0002a\u0001Q!\u0012\u0001k\f\u0005\u0006{\u0011\u0001\rA\u0010\u0015\u0003%>BQa\u0011\u0003A\u0002\u0011C#\u0001V\u0018\u0002\u000f\u0019Lg\u000eZ(oKR\u0019\u0001LX6\u0011\u0005ecV\"\u0001.\u000b\u0005m\u001b\u0012!B7pI\u0016d\u0017BA/[\u00059AF\u000eZ+tKJ\u0004&o\u001c4jY\u0016DQaX\u0003A\u0002\u0001\f\u0001\"^:fe:\fW.\u001a\t\u0003C\"t!A\u00194\u0011\u0005\r|R\"\u00013\u000b\u0005\u0015\\\u0012A\u0002\u001fs_>$h(\u0003\u0002h?\u00051\u0001K]3eK\u001aL!!\u001b6\u0003\rM#(/\u001b8h\u0015\t9w\u0004C\u0003m\u000b\u0001\u0007Q.A\bm_\u0006$7I]3eK:$\u0018.\u00197t!\tqb.\u0003\u0002p?\t9!i\\8mK\u0006tGC\u0001-r\u0011\u0015yf\u00011\u0001a\u00039\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u0016$2\u0001^<y!\tqR/\u0003\u0002w?\t!QK\\5u\u0011\u0015yv\u00011\u0001a\u0011\u001dIx\u0001%AA\u00025\f\u0001#\u00198bYf$\u0018nY:F]\u0006\u0014G.\u001a3\u00023\r\u0014X-\u0019;f\u001fJ,\u0006\u000fZ1uKV\u001bXM\u001d)s_\u001aLG.\u001a\u000b\u0003irDQ! \u0005A\u0002a\u000bq\u0001\u001d:pM&dW-A\u000fsKZ|7.\u001a'pO&t\u0017\t\u001c7po\u0016$\u0017iY2pe\u0012Lgn\u001a+p)\u0015A\u0016\u0011AA\u0002\u0011\u0015i\u0018\u00021\u0001Y\u0011\u0019A\u0015\u00021\u0001\u0002\u0006A!\u0011qAA\u0005\u001b\u00059\u0015bAA\u0006\u000f\n9A*[2f]N,\u0017!G2pk:$Xk]3s/&$\b\u000eT8hS:\fE\u000e\\8xK\u0012$\"!!\u0005\u0011\u0007y\t\u0019\"C\u0002\u0002\u0016}\u00111!\u00138u\u0003A)\b\u000fZ1uK2\u000b7\u000f^!di&4X\r\u0006\u0004\u0002\u0012\u0005m\u0011Q\u0004\u0005\u0006?.\u0001\r\u0001\u0019\u0005\b\u0003?Y\u0001\u0019AA\u0011\u0003\u0011!\u0017\r^3\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005!Q\u000f^5m\u0015\t\tY#\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003K\u0011A\u0001R1uK\u0006Q1m\\;oiV\u001bXM]:\u0015\u0011\u0005U\u00121HA\u001f\u0003\u0003\u00022AHA\u001c\u0013\r\tId\b\u0002\u0005\u0019>tw\rC\u0003`\u0019\u0001\u0007\u0001\r\u0003\u0004\u0002@1\u0001\r\u0001Y\u0001\tMVdGNT1nK\"1\u00111\t\u0007A\u0002\u0001\fQ!Z7bS2\f1\u0003\\5ti\u0006cG.V:feB\u0013xNZ5mKN$B\"!\u0013\u0002P\u0005E\u00131KA+\u0003[\u0002R!a\t\u0002LaKA!!\u0014\u0002&\t!A*[:u\u0011\u0015yV\u00021\u0001a\u0011\u0019\ty$\u0004a\u0001A\"1\u00111I\u0007A\u0002\u0001Dq!a\u0016\u000e\u0001\u0004\tI&\u0001\u0004qC\u001eLgn\u001a\t\u0005\u00037\nI'\u0004\u0002\u0002^)!\u0011qLA1\u0003\r!Go\u001c\u0006\u0005\u0003G\n)'A\u0002ba&T1!a\u001a\u0016\u0003\u0019)gnZ5oK&!\u00111NA/\u0005\u0019\u0001\u0016mZ5oO\"9\u0011qN\u0007A\u0002\u0005E\u0014!B8sI\u0016\u0014\b\u0003BA.\u0003gJA!!\u001e\u0002^\tAqJ\u001d3fe&tw\rK\u0002\u0001\u0003s\u0002B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007f:\u0014AC:uKJ,w\u000e^=qK&!\u00111QA?\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class UserProfileServiceImpl
implements UserProfileService {
    @Autowired
    private final XldUserProfileRepository xldUserProfileRepository;
    @Autowired
    private final LicenseService licenseService;

    @Override
    public boolean createOrUpdate$default$2() {
        return UserProfileService.createOrUpdate$default$2$(this);
    }

    @Override
    public XldUserProfile findOne(String username, boolean loadCredentials) {
        return (XldUserProfile)this.xldUserProfileRepository.findOne(username, loadCredentials).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("No user profile found for user: " + username, new Object[0]);
        });
    }

    @Override
    public XldUserProfile findOne(String username) {
        return this.findOne(username, false);
    }

    @Override
    public void createOrUpdate(String username, boolean analyticsEnabled) {
        Option<XldUserProfile> option = this.xldUserProfileRepository.findOne(username, this.xldUserProfileRepository.findOne$default$2());
        if (option instanceof Some) {
            this.xldUserProfileRepository.updateProfile(username, analyticsEnabled);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.xldUserProfileRepository.createProfile(username, analyticsEnabled);
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void createOrUpdateUserProfile(XldUserProfile profile) {
        XldUserProfile updatedProfile = this.revokeLoginAllowedAccordingTo(profile, this.licenseService.getLicense());
        Option<XldUserProfile> option = this.xldUserProfileRepository.findOne(updatedProfile.username(), this.xldUserProfileRepository.findOne$default$2());
        if (option instanceof Some) {
            this.xldUserProfileRepository.updateUserProfile(updatedProfile);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.xldUserProfileRepository.createUserProfile(updatedProfile);
            return;
        }
        throw new MatchError(option);
    }

    private XldUserProfile revokeLoginAllowedAccordingTo(XldUserProfile profile, License license) {
        int maxNumberOfUsers;
        if (!profile.loginAllowed()) {
            return profile;
        }
        if (license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS) != null && BoxesRunTime.boxToInteger((int)(maxNumberOfUsers = Integer.parseInt(license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS)))) != null && maxNumberOfUsers <= this.countUserWithLoginAllowed()) {
            return XldUserProfile$.MODULE$.apply(profile.username(), profile.analyticsEnabled(), profile.fullName(), profile.email(), false, profile.lastActive(), profile.isInternal());
        }
        return profile;
    }

    @Override
    public int countUserWithLoginAllowed() {
        return this.xldUserProfileRepository.countUserWithLoginAllowed();
    }

    @Override
    public int updateLastActive(String username, Date date) {
        return this.xldUserProfileRepository.updateLastActive(username, date);
    }

    @Override
    public long countUsers(String username, String fullName, String email) {
        return this.xldUserProfileRepository.countUsers(username, fullName, email);
    }

    @Override
    public List<XldUserProfile> listAllUserProfiles(String username, String fullName, String email, Paging paging, Ordering order) {
        return this.xldUserProfileRepository.listAllUserProfiles(username, fullName, email, paging, order);
    }

    public UserProfileServiceImpl(@Autowired XldUserProfileRepository xldUserProfileRepository, @Autowired RoleService roleService, @Autowired LicenseService licenseService) {
        this.xldUserProfileRepository = xldUserProfileRepository;
        this.licenseService = licenseService;
    }
}

