package com.xebialabs.deployit.security

import com.xebialabs.deployit.security.ReadOnlyAdminRoleService.ADMIN_READ_ONLY_ROLE_NAME
import org.springframework.security.core.context.SecurityContextHolder

import scala.jdk.CollectionConverters._

object ReadOnlyAdminRoleService {
  final val ADMIN_READ_ONLY_ROLE_NAME = "deploy_admin_read_only"
}

abstract class ReadOnlyAdminRoleService extends RoleService {

  override def isReadOnlyAdmin(): Boolean = {
    val authentication = SecurityContextHolder.getContext.getAuthentication
    val allRoles = getRolesFor(authentication)
    allRoles.asScala.map(_.getName).contains(ADMIN_READ_ONLY_ROLE_NAME)
  }
}
