/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.client;

import ai.digital.deploy.permissions.api.rest.dto.RoleDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPrincipalsDto;
import ai.digital.deploy.permissions.client.RolePrincipalsServiceClient;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.ReadOnlyAdminRoleService;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.client.RoleAssignmentUnsuporrtedException;
import com.xebialabs.deployit.security.client.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="deployRoleServiceClient")
@ScalaSignature(bytes="\u0006\u0005\t\rd\u0001\u0002\u0010 \u0001)B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005s!Aa\t\u0001BC\u0002\u0013\u0005q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003I\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u00159\b\u0001\"\u0011y\u0011\u00199\b\u0001\"\u0011\u0002\u0012!1q\u000f\u0001C\u0005\u0003/Aq!a\u0007\u0001\t\u0003\ni\u0002C\u0004\u0002\u001c\u0001!\t%!\u0016\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011q\f\u0001\u0005B\u00055\u0004bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\t)\n\u0001C!\u0003/Cq!!&\u0001\t\u0003\ny\nC\u0004\u0002*\u0002!\t%a+\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAe\u0001\u0011\u0005\u00131\u001a\u0005\b\u0003+\u0004A\u0011IAl\u0011\u001d\tY\u000e\u0001C\u0005\u0003;Dq!a@\u0001\t\u0003\u0012\t\u0001C\u0004\u0002\u0000\u0002!\tEa\u0002\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0005E\u0011v\u000e\\3TKJ4\u0018nY3DY&,g\u000e\u001e\u0006\u0003A\u0005\naa\u00197jK:$(B\u0001\u0012$\u0003!\u0019XmY;sSRL(B\u0001\u0013&\u0003!!W\r\u001d7ps&$(B\u0001\u0014(\u0003%AXMY5bY\u0006\u00147OC\u0001)\u0003\r\u0019w.\\\u0002\u0001'\r\u00011f\f\t\u0003Y5j\u0011!I\u0005\u0003]\u0005\u0012\u0001DU3bI>sG._!e[&t'k\u001c7f'\u0016\u0014h/[2f!\t\u0001T'D\u00012\u0015\t\u00114'A\u0003tY\u001a$$NC\u00015\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001c2\u0005\u001daunZ4j]\u001e\f\u0011C]8mKN+'O^5dK\u000ec\u0017.\u001a8u+\u0005I\u0004C\u0001\u001eE\u001b\u0005Y$B\u0001\u0011=\u0015\tid(A\u0006qKJl\u0017n]:j_:\u001c(BA A\u0003\u0019!W\r\u001d7ps*\u0011\u0011IQ\u0001\bI&<\u0017\u000e^1m\u0015\u0005\u0019\u0015AA1j\u0013\tq2(\u0001\ns_2,7+\u001a:wS\u000e,7\t\\5f]R\u0004\u0013a\u0007:pY\u0016\u0004&/\u001b8dSB\fGn]*feZL7-Z\"mS\u0016tG/F\u0001I!\tQ\u0014*\u0003\u0002Kw\tY\"k\u001c7f!JLgnY5qC2\u001c8+\u001a:wS\u000e,7\t\\5f]R\fAD]8mKB\u0013\u0018N\\2ja\u0006d7oU3sm&\u001cWm\u00117jK:$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u001dB\u0003\u0007CA(\u0001\u001b\u0005y\u0002\"B\u001c\u0006\u0001\u0004I\u0004F\u0001)S!\t\u0019f,D\u0001U\u0015\t)f+\u0001\u0006b]:|G/\u0019;j_:T!a\u0016-\u0002\u000f\u0019\f7\r^8ss*\u0011\u0011LW\u0001\u0006E\u0016\fgn\u001d\u0006\u00037r\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002;\u0006\u0019qN]4\n\u0005}#&!C!vi><\u0018N]3e\u0011\u00151U\u00011\u0001IQ\t\u0001'+\u0001\u0006s_2,W\t_5tiN$\"\u0001\u001a6\u0011\u0005\u0015DW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\u000f\t{w\u000e\\3b]\")1N\u0002a\u0001Y\u0006A!o\u001c7f\u001d\u0006lW\r\u0005\u0002ni:\u0011aN\u001d\t\u0003_\u001al\u0011\u0001\u001d\u0006\u0003c&\na\u0001\u0010:p_Rt\u0014BA:g\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M4\u0017AC2pk:$(k\u001c7fgR!\u0011\u0010`A\u0007!\t)'0\u0003\u0002|M\n!Aj\u001c8h\u0011\u0015ix\u00011\u0001\u007f\u0003MygnQ8oM&<WO]1uS>t\u0017\n^3n!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005!A.\u00198h\u0015\t\t9!\u0001\u0003kCZ\f\u0017\u0002BA\u0006\u0003\u0003\u0011aAT;nE\u0016\u0014\bBBA\b\u000f\u0001\u0007A.A\u0006s_2,\u0007+\u0019;uKJtG#B=\u0002\u0014\u0005U\u0001\"B?\t\u0001\u0004a\u0007BBA\b\u0011\u0001\u0007A\u000eF\u0002z\u00033Aa!a\u0004\n\u0001\u0004a\u0017\u0001C4fiJ{G.Z:\u0015\u0011\u0005}\u0011\u0011GA\u001a\u0003\u0017\u0002b!!\t\u0002(\u0005-RBAA\u0012\u0015\u0011\t)#!\u0002\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003S\t\u0019C\u0001\u0003MSN$\bc\u0001\u0017\u0002.%\u0019\u0011qF\u0011\u0003\tI{G.\u001a\u0005\u0007\u0003\u001fQ\u0001\u0019\u00017\t\u000f\u0005U\"\u00021\u0001\u00028\u00051\u0001/Y4j]\u001e\u0004B!!\u000f\u0002H5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0002ei>TA!!\u0011\u0002D\u0005\u0019\u0011\r]5\u000b\u0007\u0005\u00153%\u0001\u0004f]\u001eLg.Z\u0005\u0005\u0003\u0013\nYD\u0001\u0004QC\u001eLgn\u001a\u0005\b\u0003\u001bR\u0001\u0019AA(\u0003\u0015y'\u000fZ3s!\u0011\tI$!\u0015\n\t\u0005M\u00131\b\u0002\t\u001fJ$WM]5oORQ\u0011qDA,\u00033\nY&!\u0018\t\u000bu\\\u0001\u0019\u00017\t\r\u0005=1\u00021\u0001m\u0011\u001d\t)d\u0003a\u0001\u0003oAq!!\u0014\f\u0001\u0004\ty%A\u0006hKR\u0014v\u000e\\3t\r>\u0014HCCA\u0010\u0003G\n9'!\u001b\u0002l!1\u0011Q\r\u0007A\u00021\f\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\t\r\u0005=A\u00021\u0001m\u0011\u001d\t)\u0004\u0004a\u0001\u0003oAq!!\u0014\r\u0001\u0004\ty\u0005\u0006\u0006\u0002 \u0005=\u0014\u0011QAB\u0003\u000bCq!!\u001d\u000e\u0001\u0004\t\u0019(\u0001\u0003bkRD\u0007\u0003BA;\u0003{j!!a\u001e\u000b\t\u0005e\u00141P\u0001\u0005G>\u0014XM\u0003\u0002#5&!\u0011qPA<\u00059\tU\u000f\u001e5f]RL7-\u0019;j_:Da!a\u0004\u000e\u0001\u0004a\u0007bBA\u001b\u001b\u0001\u0007\u0011q\u0007\u0005\b\u0003\u001bj\u0001\u0019AA(\u0003I9W\r\u001e*pY\u00164uN\u001d*pY\u0016t\u0015-\\3\u0015\t\u0005-\u00121\u0012\u0005\u0006W:\u0001\r\u0001\\\u0001\u0011O\u0016$(k\u001c7f\r>\u0014(k\u001c7f\u0013\u0012$B!a\u000b\u0002\u0012\"1\u00111S\bA\u00021\faA]8mK&#\u0017a\u0005:fC\u0012\u0014v\u000e\\3BgNLwM\\7f]R\u001cH\u0003CA\u0010\u00033\u000bY*!(\t\r\u0005=\u0001\u00031\u0001m\u0011\u001d\t)\u0004\u0005a\u0001\u0003oAq!!\u0014\u0011\u0001\u0004\ty\u0005\u0006\u0006\u0002 \u0005\u0005\u00161UAS\u0003OCQ!`\tA\u00021Da!a\u0004\u0012\u0001\u0004a\u0007bBA\u001b#\u0001\u0007\u0011q\u0007\u0005\b\u0003\u001b\n\u0002\u0019AA(\u0003\u0019\u0019'/Z1uKR)A.!,\u00022\"1\u0011q\u0016\nA\u00021\fAA\\1nK\")QP\u0005a\u0001Y\u0006\u00112M]3bi\u0016|%/\u00169eCR,'k\u001c7f)\u0015a\u0017qWA^\u0011\u001d\tIl\u0005a\u0001\u0003W\tqA\\3x%>dW\rC\u0003~'\u0001\u0007A.\u0001\u0004sK:\fW.\u001a\u000b\bY\u0006\u0005\u00171YAd\u0011\u0019\ty\u000b\u0006a\u0001Y\"1\u0011Q\u0019\u000bA\u00021\fqA\\3x\u001d\u0006lW\rC\u0003~)\u0001\u0007A.\u0001\u0007eK2,G/\u001a\"z\u001d\u0006lW\r\u0006\u0003\u0002N\u0006M\u0007cA3\u0002P&\u0019\u0011\u0011\u001b4\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003_+\u0002\u0019\u00017\u0002\u0015\u0011,G.\u001a;f\u0005fLE\r\u0006\u0003\u0002N\u0006e\u0007BBAJ-\u0001\u0007A.\u0001\fsK\u0006$\u0017\t\u001c7S_2,\u0017i]:jO:lWM\u001c;t)\t\ty\u000e\u0005\u0004\u0002b\u0006-\u0018q\u001e\b\u0005\u0003G\f9OD\u0002p\u0003KL\u0011aZ\u0005\u0004\u0003S4\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003S\tiOC\u0002\u0002j\u001a\u0004B!!=\u0002|6\u0011\u00111\u001f\u0006\u0005\u0003{\t)P\u0003\u0003\u0002x\u0006e\u0018\u0001\u0002:fgRT1!!\u0011=\u0013\u0011\ti0a=\u0003+I{G.Z,ji\"\u0004&/\u001b8dSB\fGn\u001d#u_\u0006!rO]5uKJ{G.Z!tg&<g.\\3oiN$B!!4\u0003\u0004!9!Q\u0001\rA\u0002\u0005}\u0011!\u0002:pY\u0016\u001cHCBAg\u0005\u0013\u0011Y\u0001C\u0003~3\u0001\u0007A\u000eC\u0004\u0003\u0006e\u0001\r!a\b\u0002\u0015\u001d,g.\u001a:bi\u0016LE\r\u0006\u0003\u0002N\nE\u0001b\u0002B\n5\u0001\u0007\u00111F\u0001\u0005e>dW-A\u0003eS\u001a4'\u0007\u0006\u0004\u0003\u001a\t\u0015\"\u0011\u0006\t\bK\nm!q\u0004B\u0010\u0013\r\u0011iB\u001a\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t5\u0014\t\u0003\\\u0005\u0004\u0005G1(aA*fi\"9!qE\u000eA\u0002\t}\u0011\u0001C8sS\u001eLg.\u00197\t\u000f\t-2\u00041\u0001\u0003 \u00059Q\u000f\u001d3bi\u0016$\u0017!\u00023jM\u001a\u001cDC\u0002B\u0019\u0005{\u0011y\u0004E\u0005f\u0005g\u00119D!\u000f\u00038%\u0019!Q\u00074\u0003\rQ+\b\u000f\\34!\u0015i'\u0011EA\u0016!\u0015i'\u0011\u0005B\u001e!\u001d)'1DA\u0016\u0003WAqAa\u000b\u001d\u0001\u0004\u00119\u0004C\u0004\u0003(q\u0001\rAa\u000e\u0002\u001f\rDWmY6EkBd\u0017nY1uKN$B!!4\u0003F!9!qI\u000fA\u0002\t%\u0013\u0001D;qI\u0006$X\r\u001a*pY\u0016\u001c\bCBAq\u0005\u0017\nY#\u0003\u0003\u0003N\u00055(aA*fc\":\u0001A!\u0015\u0003^\t}\u0003\u0003\u0002B*\u00053j!A!\u0016\u000b\u0007\t]#,\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa\u0017\u0003V\tI1i\\7q_:,g\u000e^\u0001\u0006m\u0006dW/Z\u0011\u0003\u0005C\nq\u0003Z3qY>L(k\u001c7f'\u0016\u0014h/[2f\u00072LWM\u001c;")
public class RoleServiceClient
extends ReadOnlyAdminRoleService
implements Logging {
    private final ai.digital.deploy.permissions.client.RoleServiceClient roleServiceClient;
    private final RolePrincipalsServiceClient rolePrincipalsServiceClient;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RoleServiceClient roleServiceClient = this;
        synchronized (roleServiceClient) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ai.digital.deploy.permissions.client.RoleServiceClient roleServiceClient() {
        return this.roleServiceClient;
    }

    public RolePrincipalsServiceClient rolePrincipalsServiceClient() {
        return this.rolePrincipalsServiceClient;
    }

    public boolean roleExists(String roleName) {
        return this.roleServiceClient().read(roleName).isDefined();
    }

    public long countRoles(Number onConfigurationItem, String rolePattern) {
        return this.countRoles(rolePattern);
    }

    public long countRoles(String onConfigurationItem, String rolePattern) {
        return this.countRoles(rolePattern);
    }

    private long countRoles(String rolePattern) {
        return this.roleServiceClient().countRoles(rolePattern);
    }

    public java.util.List<Role> getRoles(String rolePattern, Paging paging, Ordering order) {
        return package$.MODULE$.ListExtensions(((List)Option$.MODULE$.apply((Object)paging).map((Function1 & Serializable)p -> this.rolePrincipalsServiceClient().read(rolePattern, p.page(), p.resultsPerPage(), package$.MODULE$.getSortOrder(order), "name").data()).getOrElse((Function0 & Serializable)() -> this.rolePrincipalsServiceClient().readByRolePattern(rolePattern))).map((Function1 & Serializable)dto -> new Role(dto.role().id().toString(), dto.role().name(), package$.MODULE$.ListExtensions(dto.principals()).asJavaMutable()))).asJavaMutable();
    }

    public java.util.List<Role> getRoles(String onConfigurationItem, String rolePattern, Paging paging, Ordering order) {
        return this.getRoles(rolePattern, paging, order);
    }

    public java.util.List<Role> getRolesFor(String principal, String rolePattern, Paging paging, Ordering order) {
        return package$.MODULE$.ListExtensions(((List)Option$.MODULE$.apply((Object)paging).map((Function1 & Serializable)p -> this.rolePrincipalsServiceClient().read(principal, rolePattern, p.page(), p.resultsPerPage(), package$.MODULE$.getSortOrder(order), (String)Option$.MODULE$.apply((Object)order).map((Function1 & Serializable)x$1 -> x$1.field()).getOrElse((Function0 & Serializable)() -> "name")).data()).getOrElse((Function0 & Serializable)() -> this.rolePrincipalsServiceClient().read(principal, rolePattern))).map((Function1 & Serializable)dto -> new Role(dto.role().id().toString(), dto.role().name()))).asJavaMutable();
    }

    public java.util.List<Role> getRolesFor(Authentication auth, String rolePattern, Paging paging, Ordering order) {
        Collection principals = Permissions.authenticationToPrincipals((Authentication)auth);
        return principals.isEmpty() ? new ArrayList<Role>() : package$.MODULE$.ListExtensions(((List)Option$.MODULE$.apply((Object)paging).map((Function1 & Serializable)p -> this.rolePrincipalsServiceClient().read(CollectionConverters$.MODULE$.CollectionHasAsScala(principals).asScala().toList(), rolePattern, p.page(), p.resultsPerPage(), package$.MODULE$.getSortOrder(order), "name").data()).getOrElse((Function0 & Serializable)() -> this.rolePrincipalsServiceClient().read(CollectionConverters$.MODULE$.CollectionHasAsScala(principals).asScala().toList(), rolePattern))).map((Function1 & Serializable)dto -> new Role(dto.role().id().toString(), dto.role().name()))).asJavaMutable();
    }

    /*
     * WARNING - void declaration
     */
    public Role getRoleForRoleName(String roleName) {
        void var2_2;
        Role role = (Role)this.roleServiceClient().read(roleName).map((Function1 & Serializable)dto -> new Role(dto.id().toString(), dto.name())).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find the role [%s]", new Object[]{roleName});
        });
        role.setPrincipals(package$.MODULE$.ListExtensions(this.rolePrincipalsServiceClient().readPrincipals(roleName)).asJavaMutable());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Role getRoleForRoleId(String roleId) {
        void var2_2;
        Role role = (Role)this.roleServiceClient().readById(roleId).map((Function1 & Serializable)dto -> new Role(dto.role().id().toString(), dto.role().name(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dto.principals()).asJava())).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find the role with id [%s]", new Object[]{roleId});
        });
        return var2_2;
    }

    public java.util.List<Role> readRoleAssignments(String rolePattern, Paging paging, Ordering order) {
        return this.getRoles(rolePattern, paging, order);
    }

    public java.util.List<Role> readRoleAssignments(String onConfigurationItem, String rolePattern, Paging paging, Ordering order) {
        if (onConfigurationItem != null) {
            throw new RoleAssignmentUnsuporrtedException("Cannot assign Configuration ID to an Role - not supported action");
        }
        return this.readRoleAssignments(rolePattern, paging, order);
    }

    public String create(String name, String onConfigurationItem) {
        RoleDto roleDto = this.roleServiceClient().create(name);
        return roleDto.id().toString();
    }

    public String createOrUpdateRole(Role newRole, String onConfigurationItem) {
        Set updatedPrincipals;
        RoleWithPrincipalsDto originalRole = (RoleWithPrincipalsDto)Option$.MODULE$.apply((Object)newRole.getId()).map((Function1 & Serializable)id -> (RoleWithPrincipalsDto)this.roleServiceClient().readById(id).getOrElse((Function0 & Serializable)() -> this.roleServiceClient().create(newRole.getName(), CollectionConverters$.MODULE$.ListHasAsScala(newRole.getPrincipals()).asScala().toList()))).getOrElse((Function0 & Serializable)() -> this.roleServiceClient().create(newRole.getName(), CollectionConverters$.MODULE$.ListHasAsScala(newRole.getPrincipals()).asScala().toList()));
        Set originalPrincipals = originalRole.principals().toSet();
        Tuple2<Set<String>, Set<String>> tuple2 = this.diff2((Set<String>)originalPrincipals, (Set<String>)(updatedPrincipals = CollectionConverters$.MODULE$.ListHasAsScala(newRole.getPrincipals()).asScala().toSet()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set principalsToCreate = (Set)tuple2._1();
        Set principalsToDelete = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)principalsToCreate, (Object)principalsToDelete);
        Tuple2 tuple23 = tuple22;
        Set principalsToCreate2 = (Set)tuple23._1();
        Set principalsToDelete2 = (Set)tuple23._2();
        return this.roleServiceClient().update(originalRole.role().name(), newRole.getName(), principalsToCreate2, principalsToDelete2).role().id().toString();
    }

    public String rename(String name, String newName, String onConfigurationItem) {
        return this.roleServiceClient().rename(name, newName).id().toString();
    }

    public void deleteByName(String name) {
        this.roleServiceClient().removeAllReferences(name);
    }

    public void deleteById(String roleId) {
        Option roleDto = this.roleServiceClient().readById(roleId);
        this.roleServiceClient().removeAllReferences(((RoleWithPrincipalsDto)roleDto.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find the role for id [%s]", new Object[]{roleId});
        })).role().name());
    }

    private List<RoleWithPrincipalsDto> readAllRoleAssignments() {
        return this.rolePrincipalsServiceClient().readByRolePattern(null);
    }

    public void writeRoleAssignments(java.util.List<Role> roles) {
        this.writeRoleAssignments(null, roles);
    }

    public void writeRoleAssignments(String onConfigurationItem, java.util.List<Role> roles) {
        Tuple3 tuple3;
        if (onConfigurationItem == null) {
            Buffer convertedRoles = CollectionConverters$.MODULE$.ListHasAsScala(roles).asScala();
            this.checkDuplicates((scala.collection.immutable.Seq<Role>)convertedRoles.toSeq());
            ((IterableOnceOps)convertedRoles.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RoleServiceClient.$anonfun$writeRoleAssignments$1(x$3)))).foreach((Function1 & Serializable)role -> {
                this.generateId(role);
                return BoxedUnit.UNIT;
            });
            List originalRoles = this.readAllRoleAssignments().map((Function1 & Serializable)r -> new Role(r.role().id().toString(), r.role().name(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)r.principals()).asJava()));
            Tuple3<Set<Role>, Set<Tuple2<Role, Role>>, Set<Role>> tuple32 = this.diff3((Set<Role>)convertedRoles.toSet(), (Set<Role>)originalRoles.toSet());
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            Set toCreate = (Set)tuple32._1();
            Set toUpdate = (Set)tuple32._2();
            Set toDelete = (Set)tuple32._3();
            tuple3 = new Tuple3((Object)toCreate, (Object)toUpdate, (Object)toDelete);
        } else {
            throw new RoleAssignmentUnsuporrtedException("Cannot assign Configuration ID to an Role - not supported action");
        }
        Tuple3 tuple33 = tuple3;
        Set toCreate = (Set)tuple33._1();
        Set toUpdate = (Set)tuple33._2();
        Set toDelete = (Set)tuple33._3();
        toDelete.foreach((Function1 & Serializable)r -> {
            RoleServiceClient.$anonfun$writeRoleAssignments$4(this, r);
            return BoxedUnit.UNIT;
        });
        toCreate.foreach((Function1 & Serializable)r -> this.roleServiceClient().create(r.getName(), CollectionConverters$.MODULE$.ListHasAsScala(r.getPrincipals()).asScala().toList()));
        toUpdate.foreach((Function1 & Serializable)r -> {
            Tuple2<Set<String>, Set<String>> tuple2 = this.diff2((Set<String>)CollectionConverters$.MODULE$.ListHasAsScala(((Role)r._1()).getPrincipals()).asScala().toSet(), (Set<String>)CollectionConverters$.MODULE$.ListHasAsScala(((Role)r._2()).getPrincipals()).asScala().toSet());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Set principalsToCreate = (Set)tuple2._1();
            Set principalsToDelete = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)principalsToCreate, (Object)principalsToDelete);
            Tuple2 tuple23 = tuple22;
            Set principalsToCreate2 = (Set)tuple23._1();
            Set principalsToDelete2 = (Set)tuple23._2();
            return this.roleServiceClient().update(((Role)r._1()).getName(), ((Role)r._2()).getName(), principalsToCreate2, principalsToDelete2);
        });
    }

    private void generateId(Role role) {
        role.setId(UUID.randomUUID().toString());
    }

    private Tuple2<Set<String>, Set<String>> diff2(Set<String> original, Set<String> updated) {
        return new Tuple2((Object)updated.diff(original), (Object)original.diff(updated));
    }

    private Tuple3<Set<Role>, Set<Tuple2<Role, Role>>, Set<Role>> diff3(Set<Role> updated, Set<Role> original) {
        return new Tuple3((Object)updated.diff(original), updated.flatMap((Function1 & Serializable)u -> (Set)original.withFilter((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)RoleServiceClient.$anonfun$diff3$2(u, o))).map((Function1 & Serializable)o -> new Tuple2(o, u))), (Object)original.diff(updated));
    }

    private void checkDuplicates(scala.collection.immutable.Seq<Role> updatedRoles) {
        Map duplicateRoles = (Map)updatedRoles.groupBy((Function1 & Serializable)x$6 -> x$6.getName()).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)RoleServiceClient.$anonfun$checkDuplicates$2(x$7)));
        Checks.checkArgument((boolean)duplicateRoles.isEmpty(), (String)new StringBuilder(45).append("Roles with duplicate names [").append(duplicateRoles.keys().mkString(", ")).append("] are not allowed").toString(), (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$writeRoleAssignments$1(Role x$3) {
        return x$3.getId() == null;
    }

    public static final /* synthetic */ void $anonfun$writeRoleAssignments$4(RoleServiceClient $this, Role r) {
        $this.roleServiceClient().removeAllReferences(r.getName());
    }

    public static final /* synthetic */ boolean $anonfun$diff3$2(Role u$1, Role o) {
        Role role = u$1;
        Role role2 = o;
        return !(role != null ? !role.equals(role2) : role2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkDuplicates$2(Tuple2 x$7) {
        return ((SeqOps)x$7._2()).size() > 1;
    }

    public RoleServiceClient(@Autowired ai.digital.deploy.permissions.client.RoleServiceClient roleServiceClient, @Autowired RolePrincipalsServiceClient rolePrincipalsServiceClient) {
        this.roleServiceClient = roleServiceClient;
        this.rolePrincipalsServiceClient = rolePrincipalsServiceClient;
        Logging.$init$((Logging)this);
    }
}

