/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.sql;

import com.xebialabs.deployit.core.sql.OrderBy;
import com.xebialabs.deployit.core.sql.OrderBy$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.SelectBuilder;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlFunction$;
import com.xebialabs.deployit.core.sql.spring.Setter;
import com.xebialabs.deployit.core.sql.spring.Setter$;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.SHA256PasswordEncoder;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.deployit.security.repository.XldUserProfileRepository;
import com.xebialabs.deployit.security.sql.InternalUser;
import com.xebialabs.deployit.security.sql.UserQueries;
import com.xebialabs.deployit.security.sql.UserSchema$;
import com.xebialabs.deployit.security.sql.package$;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\f\u0019\u0001\rB\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005m!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003F\u0011!a\u0005A!b\u0001\n\u0007i\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bU\u0003A\u0011\u0001,\t\u000fM\u0004!\u0019!C\u0001i\"1\u0001\u0010\u0001Q\u0001\nUDQ!\u001f\u0001\u0005\niDq!a\n\u0001\t\u0003\nI\u0003C\u0004\u00024\u0001!I!!\u000e\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA,\u0001\u0011\u0005\u0013\u0011\f\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\ti\u0007\u0001C!\u0003_Bq!!\u001c\u0001\t\u0003\n9\bC\u0004\u0002\u0002\u0002!\t%a!\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u0011q\u0012\u0001\u0005B\u0005E\u0005bBAH\u0001\u0011\u0005\u0013q\u0014\u0002\u000f'FdWk]3s'\u0016\u0014h/[2f\u0015\tI\"$A\u0002tc2T!a\u0007\u000f\u0002\u0011M,7-\u001e:jifT!!\b\u0010\u0002\u0011\u0011,\u0007\u000f\\8zSRT!a\b\u0011\u0002\u0013a,'-[1mC\n\u001c(\"A\u0011\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001!C\u0006\r\t\u0003K)j\u0011A\n\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u0019y%M[3diB\u0011QFL\u0007\u00025%\u0011qF\u0007\u0002\f+N,'oU3sm&\u001cW\r\u0005\u00022e5\t\u0001$\u0003\u000241\tYQk]3s#V,'/[3t\u00031QGMY2UK6\u0004H.\u0019;f+\u00051\u0004CA\u001cA\u001b\u0005A$BA\u001d;\u0003\u0011\u0019wN]3\u000b\u0005mb\u0014\u0001\u00026eE\u000eT!!\u0010 \u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aP\u0001\u0004_J<\u0017BA!9\u00051QEMY2UK6\u0004H.\u0019;f\u00035QGMY2UK6\u0004H.\u0019;fA\u0005)Ro]3s!J|g-\u001b7f%\u0016\u0004xn]5u_JLX#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!S\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011!j\u0012\u0002\u001912$Wk]3s!J|g-\u001b7f%\u0016\u0004xn]5u_JL\u0018AF;tKJ\u0004&o\u001c4jY\u0016\u0014V\r]8tSR|'/\u001f\u0011\u0002\u0015M\u001c\u0007.Z7b\u0013:4w.F\u0001O!\ty%+D\u0001Q\u0015\tI\u0012K\u0003\u0002:9%\u00111\u000b\u0015\u0002\u000b'\u000eDW-\\1J]\u001a|\u0017aC:dQ\u0016l\u0017-\u00138g_\u0002\na\u0001P5oSRtDcA,mcR\u0011\u0001,\u0017\t\u0003c\u0001AQ\u0001T\u0004A\u00049CC!W.fMB\u0011AlY\u0007\u0002;*\u0011alX\u0001\u000bC:tw\u000e^1uS>t'B\u00011b\u0003\u001d1\u0017m\u0019;pefT!A\u0019\u001f\u0002\u000b\t,\u0017M\\:\n\u0005\u0011l&!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u00059\u0017AC7bS:\u001c6\r[3nC\"\u0012\u0011,\u001b\t\u00039*L!a[/\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u0002\u001b\b\u0001\u00041\u0004\u0006\u00027\\K:\f\u0013a\\\u0001\u0011[\u0006LgN\u00133cGR+W\u000e\u001d7bi\u0016D#\u0001\\5\t\u000b\r;\u0001\u0019A#)\u0005EL\u0017a\u00049bgN<xN\u001d3F]\u000e|G-\u001a:\u0016\u0003U\u0004\"!\f<\n\u0005]T\"!F*I\u0003J*d\u0007U1tg^|'\u000fZ#oG>$WM]\u0001\u0011a\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u0002\n!c^5uQV\u001bXM\u001d8b[\u00164\u0015\u000e\u001c;feR)10a\u0001\u0002\u001eA\u0011Ap`\u0007\u0002{*\ta0A\u0003tG\u0006d\u0017-C\u0002\u0002\u0002u\u00141!\u00118z\u0011\u001d\t)A\u0003a\u0001\u0003\u000f\t\u0001\"^:fe:\fW.\u001a\t\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005M\u0001cAA\u0007{6\u0011\u0011q\u0002\u0006\u0004\u0003#\u0011\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0016u\fa\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000b{\"9\u0011q\u0004\u0006A\u0002\u0005\u0005\u0012a\u00022vS2$WM\u001d\t\u0004\u001f\u0006\r\u0012bAA\u0013!\ni1+\u001a7fGR\u0014U/\u001b7eKJ\f!bY8v]R,6/\u001a:t)\u0011\tY#!\r\u0011\u0007q\fi#C\u0002\u00020u\u0014A\u0001T8oO\"9\u0011QA\u0006A\u0002\u0005\u001d\u0011AE2iK\u000e\\g+\u00197jIV\u001bXM\u001d8b[\u0016$B!a\u000e\u0002>A\u0019A0!\u000f\n\u0007\u0005mRP\u0001\u0003V]&$\bbBA\u0003\u0019\u0001\u0007\u0011qA\u0001\u0013G\",7m[!e[&tWk]3s]\u0006lW\r\u0006\u0003\u00028\u0005\r\u0003bBA\u0003\u001b\u0001\u0007\u0011qA\u0001\te\u0016\fG-V:feR!\u0011\u0011JA+!\u0015a\u00181JA(\u0013\r\ti% \u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007E\n\t&C\u0002\u0002Ta\u0011A\"\u00138uKJt\u0017\r\\+tKJDq!!\u0002\u000f\u0001\u0004\t9!\u0001\u0003sK\u0006$G\u0003BA.\u0003C\u00022!LA/\u0013\r\tyF\u0007\u0002\u0005+N,'\u000fC\u0004\u0002\u0006=\u0001\r!a\u0002\u0002\u0019\u0005,H\u000f[3oi&\u001c\u0017\r^3\u0015\r\u0005]\u0012qMA5\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000fAq!a\u001b\u0011\u0001\u0004\t9!\u0001\u0005qCN\u001cxo\u001c:e\u00039iw\u000eZ5gsB\u000b7o]<pe\u0012$b!a\u000e\u0002r\u0005M\u0004bBA\u0003#\u0001\u0007\u0011q\u0001\u0005\b\u0003k\n\u0002\u0019AA\u0004\u0003-qWm\u001e)bgN<xN\u001d3\u0015\u0011\u0005]\u0012\u0011PA>\u0003{Bq!!\u0002\u0013\u0001\u0004\t9\u0001C\u0004\u0002vI\u0001\r!a\u0002\t\u000f\u0005}$\u00031\u0001\u0002\b\u0005Yq\u000e\u001c3QCN\u001cxo\u001c:e\u0003\u0019!W\r\\3uKR!\u0011qGAC\u0011\u001d\t)a\u0005a\u0001\u0003\u000f\taa\u0019:fCR,GCBA\u001c\u0003\u0017\u000bi\tC\u0004\u0002\u0006Q\u0001\r!a\u0002\t\u000f\u0005-D\u00031\u0001\u0002\b\u0005iA.[:u+N,'O\\1nKN$\"!a%\u0011\r\u0005U\u00151TA\u0004\u001b\t\t9JC\u0002\u0002\u001a\"\nA!\u001e;jY&!\u0011QTAL\u0005\u0011a\u0015n\u001d;\u0015\u0011\u0005M\u0015\u0011UAR\u0003wCq!!\u0002\u0017\u0001\u0004\t9\u0001C\u0004\u0002&Z\u0001\r!a*\u0002\rA\fw-\u001b8h!\u0011\tI+a.\u000e\u0005\u0005-&\u0002BAW\u0003_\u000b1\u0001\u001a;p\u0015\u0011\t\t,a-\u0002\u0007\u0005\u0004\u0018NC\u0002\u00026r\ta!\u001a8hS:,\u0017\u0002BA]\u0003W\u0013a\u0001U1hS:<\u0007bBA_-\u0001\u0007\u0011qX\u0001\u0006_J$WM\u001d\t\u0005\u0003S\u000b\t-\u0003\u0003\u0002D\u0006-&\u0001C(sI\u0016\u0014\u0018N\\4)\r\u0001\t9-ZAk!\u0011\tI-!5\u000e\u0005\u0005-'b\u00010\u0002N*\u0019\u0011q\u001a\u001f\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003'\fYMA\u0007Ue\u0006t7/Y2uS>t\u0017\r\\\u0011\u0003\u0003/\fa#\\1j]R\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0015\b\u0001\u0005m\u0017\u0011^Av!\u0011\ti.!:\u000e\u0005\u0005}'b\u00010\u0002b*\u0019\u00111\u001d\u001f\u0002\u000f\r|g\u000e^3yi&!\u0011q]Ap\u0005\u0015\u00196m\u001c9f\u0003%\u0001(o\u001c=z\u001b>$W\r\n\u0002\u0002n&!\u0011q^Ay\u00031!\u0016IU$F)~\u001bE*Q*T\u0015\u0011\t\u00190a8\u0002\u001fM\u001bw\u000e]3e!J|\u00070_'pI\u0016D3\u0001AA|!\u0011\tI0a@\u000e\u0005\u0005m(bAA\u007fy\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\t\u0005\u00111 \u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class SqlUserService
implements UserService,
UserQueries {
    private final JdbcTemplate jdbcTemplate;
    private final XldUserProfileRepository userProfileRepository;
    private final SchemaInfo schemaInfo;
    private final SHA256PasswordEncoder passwordEncoder;
    private String SELECT;
    private String SELECT_NAMES;
    private String INSERT;
    private String UPDATE;
    private String DELETE;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    @Override
    public String SELECT() {
        return this.SELECT;
    }

    @Override
    public String SELECT_NAMES() {
        return this.SELECT_NAMES;
    }

    @Override
    public String INSERT() {
        return this.INSERT;
    }

    @Override
    public String UPDATE() {
        return this.UPDATE;
    }

    @Override
    public String DELETE() {
        return this.DELETE;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_$eq(String x$1) {
        this.SELECT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_NAMES_$eq(String x$1) {
        this.SELECT_NAMES = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$INSERT_$eq(String x$1) {
        this.INSERT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$UPDATE_$eq(String x$1) {
        this.UPDATE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$DELETE_$eq(String x$1) {
        this.DELETE = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public XldUserProfileRepository userProfileRepository() {
        return this.userProfileRepository;
    }

    public SchemaInfo schemaInfo() {
        return this.schemaInfo;
    }

    public SHA256PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    private Object withUsernameFilter(String username, SelectBuilder builder) {
        return username != null ? builder.where((SqlCondition)SqlCondition$.MODULE$.like((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME()), new StringBuilder(2).append("%").append(username.toLowerCase()).append("%").toString())) : BoxedUnit.UNIT;
    }

    public long countUsers(String username) {
        SelectBuilder builder = (SelectBuilder)new SelectBuilder(UserSchema$.MODULE$.tableName(), this.schemaInfo()).select((Selectable)SqlFunction$.MODULE$.countAll());
        this.withUsernameFilter(username, builder);
        return BoxesRunTime.unboxToLong((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters(), Setter$.MODULE$.apply$default$2()), (RowMapper)new SingleColumnRowMapper(Long.TYPE))).asScala().headOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    private void checkValidUsername(String username) {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Username can neither be null nor empty.");
        }
        this.readUser(username).foreach((Function1 & Serializable)x$1 -> {
            throw new UserAlreadyExistsException(username);
        });
    }

    private void checkAdminUsername(String username) {
        if ("admin".equalsIgnoreCase(username)) {
            throw new IllegalArgumentException("Admin user cannot be deleted.");
        }
    }

    private Option<InternalUser> readUser(String username) {
        return ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().queryForList(this.SELECT(), new Object[]{username.toLowerCase()})).asScala().map((Function1 & Serializable)map -> new InternalUser((String)map.get(UserSchema$.MODULE$.USERNAME().name()), (String)map.get(UserSchema$.MODULE$.PASSWORD().name())))).headOption();
    }

    public User read(String username) {
        return (User)this.readUser(username).map((Function1 & Serializable)user -> {
            String string = user.username();
            String string2 = "admin";
            return new RepoUser(user.username(), !(string != null ? !string.equals(string2) : string2 != null));
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(14).append("No such user: ").append(username).toString(), new Object[0]);
        });
    }

    public void authenticate(String username, String password) {
        InternalUser user = (InternalUser)this.readUser(username).getOrElse((Function0 & Serializable)() -> {
            throw new AuthenticationFailureException(new StringBuilder(20).append("Cannot authenticate ").append(username).toString());
        });
        if (!this.passwordEncoder().matches((CharSequence)password, user.passwordHash())) {
            throw new AuthenticationFailureException(new StringBuilder(36).append("Wrong credentials supplied for user ").append(username).toString());
        }
    }

    public void modifyPassword(String username, String newPassword) {
        this.jdbcTemplate().update(this.UPDATE(), new Object[]{this.passwordEncoder().encode((CharSequence)newPassword), username});
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.readUser(username).foreach((Function1 & Serializable)user -> {
            SqlUserService.$anonfun$modifyPassword$1(this, oldPassword, username, newPassword, user);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(String username) {
        this.checkAdminUsername(username);
        this.jdbcTemplate().update(this.DELETE(), new Object[]{username});
        this.userProfileRepository().delete(username);
    }

    public void create(String username, String password) {
        this.checkValidUsername(username);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{username, this.passwordEncoder().encode((CharSequence)password)});
        this.userProfileRepository().createProfile(username, this.userProfileRepository().createProfile$default$2());
    }

    public java.util.List<String> listUsernames() {
        return this.jdbcTemplate().queryForList(this.SELECT_NAMES(), String.class);
    }

    public java.util.List<String> listUsernames(String username, Paging paging, Ordering order) {
        SelectBuilder builder = (SelectBuilder)new SelectBuilder(UserSchema$.MODULE$.tableName(), this.schemaInfo()).select((Selectable)UserSchema$.MODULE$.USERNAME());
        this.withUsernameFilter(username, builder);
        Object object = paging != null ? builder.showPage(paging.page(), paging.resultsPerPage()) : BoxedUnit.UNIT;
        Object object2 = order != null ? builder.orderBy((OrderBy)(order.isAscending() ? OrderBy$.MODULE$.asc((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME())) : OrderBy$.MODULE$.desc((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME())))) : BoxedUnit.UNIT;
        List names = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters(), Setter$.MODULE$.apply$default$2()), (RowMapper)package.MapRowMapper$.MODULE$)).asScala().map((Function1 & Serializable)x$2 -> x$2.get(UserSchema$.MODULE$.USERNAME().name()).toString())).toList();
        return package$.MODULE$.asMutableJavaList(names);
    }

    public static final /* synthetic */ void $anonfun$modifyPassword$1(SqlUserService $this, String oldPassword$1, String username$4, String newPassword$1, InternalUser user) {
        if (!$this.passwordEncoder().matches((CharSequence)oldPassword$1, user.passwordHash())) {
            throw new IllegalArgumentException("Failed to change password: Old password does not match.");
        }
        $this.modifyPassword(username$4, newPassword$1);
    }

    public SqlUserService(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired XldUserProfileRepository userProfileRepository, @Autowired @Qualifier(value="mainSchema") SchemaInfo schemaInfo) {
        this.jdbcTemplate = jdbcTemplate;
        this.userProfileRepository = userProfileRepository;
        this.schemaInfo = schemaInfo;
        Queries.$init$((Queries)this);
        UserQueries.$init$(this);
        this.passwordEncoder = new SHA256PasswordEncoder();
        Statics.releaseFence();
    }
}

