package com.xebialabs.deployit.security

import org.springframework.security.core.context.SecurityContextHolder

import scala.jdk.CollectionConverters._

abstract class ReadOnlyAdminRoleService extends RoleService {
  val ADMIN_READ_ONLY_ROLE_NAME = "deploy_admin_read_only"

  override def isReadOnlyAdmin(): Boolean = {
    val authentication = SecurityContextHolder.getContext.getAuthentication
    val allRoles = getRolesFor(authentication)
    allRoles.asScala.map(_.getName).contains(ADMIN_READ_ONLY_ROLE_NAME)
  }
}
