package com.xebialabs.deployit.security.service.impl

import com.xebialabs.deployit.engine.spi.exception.{DeployitException, HttpResponseCodeResult, SuppressStackTrace}
import com.xebialabs.deployit.security.model.XldUserCredentials
import com.xebialabs.deployit.security.repository.{XldUserCredentialsRepository, XldUserProfileRepository}
import com.xebialabs.deployit.security.service.UserCredentialsService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class UserCredentialsServiceImpl(@Autowired xldUserProfileRepository: XldUserProfileRepository,
                                 @Autowired xldUserCredentialsRepository: XldUserCredentialsRepository) extends UserCredentialsService {
  override def findOne(id: Long): XldUserCredentials =
    xldUserCredentialsRepository
      .findOne(id)
      .getOrElse(throw new CredentialsNotFoundException(s"No user credentials found for id: $id"))

  override def findDefaultCredentialsByProfileUsername(username: String): XldUserCredentials =
    xldUserCredentialsRepository
      .findDefaultCredentialsByProfileUsername(username)
      .getOrElse(throw new CredentialsNotFoundException(s"No default user credentials found for id: $username"))

  override def findByProfileUsername(username: String): Set[XldUserCredentials] =
    xldUserCredentialsRepository
      .findByProfileUsername(username)

  override def saveCredentials(xldUserCredentials: XldUserCredentials): Long = {
    xldUserProfileRepository.findOne(xldUserCredentials.profileUsername)
        .getOrElse(xldUserProfileRepository.createProfile(xldUserCredentials.profileUsername))
    xldUserCredentialsRepository.saveCredentials(xldUserCredentials)
  }

  override def updateCredentials(xldUserCredentials: XldUserCredentials): Long =
    xldUserCredentialsRepository.updateCredentials(xldUserCredentials)
}

@HttpResponseCodeResult(statusCode = 404)
@SuppressStackTrace(suppressStackTrace = true)
class CredentialsNotFoundException(message: String) extends DeployitException(message)
