package com.xebialabs.deployit.security.model

case class XldUserProfile(username: String, analyticsEnabled: Boolean, credentials: Set[XldUserCredentials])

object XldUserProfile {
  def apply(username: String, analyticsEnabled: Boolean): XldUserProfile = XldUserProfile(username, analyticsEnabled, Set.empty[XldUserCredentials])
  def apply(username: String, analyticsEnabled: Boolean, credentials: XldUserCredentials*): XldUserProfile = XldUserProfile(username, analyticsEnabled, credentials.toSet)
}
