package com.xebialabs.deployit.repository.sql.specific.columns

import com.xebialabs.deployit.core.sql._
import com.xebialabs.deployit.core.sql.batch.BatchCommandWithSetter
import com.xebialabs.deployit.core.sql.spring.Setter
import com.xebialabs.deployit.repository.sql.base.CiPKType
import org.springframework.jdbc.core.JdbcTemplate

import scala.collection.mutable

class PropertyColumnsInserter(val table: TableName, val idColumn: ColumnName, val columns: Map[String, ColumnName] = Map())
                             (implicit val jdbcTemplate: JdbcTemplate, implicit val schemaInfo: SchemaInfo)
  extends Queries {
  def column(propertyName: String): Option[ColumnName] = columns.get(propertyName)
  def setValues(pk: CiPKType, values: mutable.Map[ColumnName, Any]): Unit = {
    val entries = values.toList
    jdbcTemplate.update(createStatement(entries), Setter(pk +: entries.map(_._2)))
  }
  def setValuesInBatch(pk: CiPKType, values: mutable.Map[ColumnName, Any]): BatchCommandWithSetter = {
    val entries = values.toList
    BatchCommandWithSetter(createStatement(entries), Setter(pk +: entries.map(_._2)))
  }
  private def createStatement(entries: List[(ColumnName, Any)]): String = {
    val allColumns = idColumn :: entries.map(_._1)
    sqlb"insert into $table ${allColumns.map(_.build(None)).mkString("(", ", ", ")")} values ${List.fill(allColumns.length)("?").mkString("(",", ",")")}"
  }
}
