package com.xebialabs.deployit.repository.sql.artifacts

import java.io.InputStream

import com.xebialabs.deployit.repository.sql.base.CiPKType

/**
  * Interface responsible to handle the artifact's data, checksum and location for internal
  * artifacts (DB or File system storage).
  */
trait ArtifactDataRepository {

  def countArtifacts: Int

  def refFromChecksum(checksum: String): String

  def store(pk: CiPKType, inputStream: InputStream): Unit

  def insert(pk: CiPKType, reference: String): Unit

  def copy(fromId: String, pk: CiPKType): Unit

  def retrieve(id: String): InputStream

  def delete(pk: CiPKType): Unit
}