package com.xebialabs.deployit.repository.sql.cache

import ai.digital.configuration.central.deploy.{CacheConfiguration, CachesProperties}
import ai.digital.deploy.cache.config.CacheProvider
import ai.digital.deploy.cache.service.{AppCacheDataService}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class CiPathCacheDataService(@Autowired(required = false) override val cacheProvider: CacheProvider,
                             @Autowired cachesProperties: CachesProperties) extends AppCacheDataService[String, java.util.Map[String, Object]] {
  override val cacheName: String = "CI_PATH_CACHE"
  override val cacheConfiguration: CacheConfiguration = cachesProperties.appCaches.ciPathCacheConfiguration
}