package com.xebialabs.deployit.repository.sql.cache

import ai.digital.configuration.central.deploy.CachesProperties
import org.springframework.stereotype.Component

import java.util.concurrent.atomic.AtomicReference

@Component
class CiCacheDataServicesHolder(ciCacheDataServiceFacade: CiCacheDataServiceFacade,
                                cachesProperties: CachesProperties) {
  CiCacheDataServicesHolder.ciCacheDataServiceFacade.set(ciCacheDataServiceFacade)
  CiCacheDataServicesHolder.cachesProperties.set(cachesProperties)
}

object CiCacheDataServicesHolder {
  private val ciCacheDataServiceFacade = new AtomicReference[CiCacheDataServiceFacade]
  private val cachesProperties = new AtomicReference[CachesProperties]

  def getCiCacheDataServiceFacade: CiCacheDataServiceFacade = CiCacheDataServicesHolder.ciCacheDataServiceFacade.get()
  def getCachesProperties: CachesProperties = CiCacheDataServicesHolder.cachesProperties.get()
}
