package com.xebialabs.deployit.repository.sql.commands.util

import com.xebialabs.deployit.core.events.ChangeSetEvent
import com.xebialabs.deployit.repository.sql.commands._
import scala.jdk.CollectionConverters._

object CommandConverter {
  def toChangeSetEvent(commands: List[ChangeSetCommand]): ChangeSetEvent = {
    commands.foldLeft(ChangeSetEvent()) { case (event, command) =>
      command match {
        case cmd: CreateCommand => event.copy(createCis = cmd.cis.asJavaCollection)
        case cmd: UpdateCommand => event.copy(updateCis = cmd.cis.asJava)
        case cmd: MoveCommand => event.copy(moveCis = cmd.moveCis.asJavaCollection)
        case cmd: RenameCommand => event.copy(renameCis = cmd.renameCis.asJavaCollection)
        case cmd: CopyCommand => event.copy(copyCis = cmd.copyCis.asJavaCollection)
        case cmd: DeleteCommand => event.copy(deleteCiIds = cmd.ids.map(_.b).asJavaCollection)
        case _ => event
      }
    }
  }
}
