package com.xebialabs.deployit.repository.sql.specific.columns

import com.xebialabs.deployit.core.sql.SqlFunction.?
import com.xebialabs.deployit.core.sql._
import com.xebialabs.deployit.repository.sql.base.CiPKType
import org.springframework.jdbc.core.JdbcTemplate

class PropertyColumnsReader(val table: TableName, val idColumn: ColumnName, val columns: Map[String, ColumnName])
                           (implicit val jdbcTemplate: JdbcTemplate, implicit val schemaInfo: SchemaInfo)
  extends Queries {
  private val builder = new SelectBuilder(table)
  columns.values.foreach(builder.select)
  builder.where(SqlCondition.equals(idColumn, ?))
  def readProperties(pk: CiPKType): Map[String, Any] = {
    if (columns.nonEmpty) {
      val map = jdbcTemplate.queryForMap(builder.query, pk)
      columns.map { case (propertyName, columnName) =>
        propertyName -> map.get(columnName.name)
      }
    } else Map()
  }
}
