package com.xebialabs.deployit.repository.sql.commands

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.sql.{CiPkAndType, CiRepository}
import com.xebialabs.deployit.repository.sql.base.{idToPath, parentPath}
import com.xebialabs.deployit.sql.base.schema.CIS

trait CiPreloadCache {

  val ciRepository: CiRepository

  protected def preloadCacheWithParents(cis: Iterable[ConfigurationItem], context: ChangeSetContext): Unit = {
    val parentPaths = cis.flatMap(ci => parentPath(ci.getId))
    preloadCacheForPaths(parentPaths, context)
  }

  protected def preloadCacheForCis(cis: Iterable[ConfigurationItem], context: ChangeSetContext): Unit = {
    val paths = cis.map(ci => idToPath(ci.getId))
    preloadCacheForPaths(paths, context)
  }

  private def preloadCacheForPaths(paths: Iterable[String], context: ChangeSetContext): Unit = {
    ciRepository.findCiIdAndTypeFromPaths(paths.toSeq)
      .map(m => (m.get(CIS.path.name).asInstanceOf[String], CiPkAndType(m)))
      .foreach { case (path, ciType) => context.pathCache.put(path, ciType) }
  }
}
