package com.xebialabs.deployit.repository.sql.specific.columns

import com.xebialabs.deployit.core.sql.spring.{MapRowMapper, Setter}
import com.xebialabs.deployit.core.sql.util._
import com.xebialabs.deployit.core.sql.{SqlCondition => cond, _}
import com.xebialabs.deployit.repository.sql.base.{CiPKType, asCiPKType}
import org.springframework.jdbc.core.JdbcTemplate

import scala.jdk.CollectionConverters._

class PropertyColumnsReferenceFinder(val table: TableName, val idColumn: ColumnName, val columns: List[ColumnName])
                                    (implicit val jdbcTemplate: JdbcTemplate, implicit val schemaInfo: SchemaInfo)
  extends Queries {

  def findReferences(pks: Seq[CiPKType]): Seq[(CiPKType, CiPKType)] = {
    queryWithInClause(pks) { group =>
      findReferencesBuilder(group).map { builder =>
        columns.foreach(builder.select)
        jdbcTemplate.query(builder.query, Setter(builder.parameters), MapRowMapper).asScala.flatMap { map =>
          val referencePk = asCiPKType(map.get(idColumn.name))
          columns.filter(c => map.containsKey(c.name)).map(c => (referencePk, asCiPKType(map.get(c.name))))
        }
      }
    }.flatten
  }

  def findReferencesBuilder(pks: Seq[CiPKType]): Option[SelectBuilder] = {
    if (columns.nonEmpty) {
      val builder = new SelectBuilder(table)
        .distinct()
        .select(idColumn)
        .where(cond.or(columns.map {
          cond.in(_, pks)
        }))
      Option(builder)
    } else {
      None
    }
  }
}
