package com.xebialabs.deployit.repository

import com.xebialabs.deployit.booter.local.CiRoots
import com.xebialabs.deployit.repository.internal.Root
import com.xebialabs.deployit.server.api.upgrade.{ApplicableRepoTypes, RepoType, RepositoryInitialization}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

import scala.jdk.CollectionConverters._

@ApplicableRepoTypes(Array(RepoType.SQL))
class SqlRepositoryInitializer(@Autowired val repositoryService: SqlRepositoryService) extends RepositoryInitialization with Logging {

  override def doInitialize(): Unit = {
    val roots = CiRoots.all().asScala.filterNot(repositoryService.exists).map(createRoot)
    logger.debug(s"Creating root nodes: $roots.")
    val set = roots.foldLeft(new ChangeSet) { (c, r) => c.create(r); c }
    repositoryService.execute(set)
  }

  private def createRoot(id: String) = {
    val root = new Root()
    root.setId(id)
    root
  }

  override def getComponent = "deployit"
}
