package com.xebialabs.deployit.repository.sql.cache

import ai.digital.configuration.central.deploy.{CacheConfiguration, CachesProperties}
import ai.digital.deploy.cache.config.CacheProvider
import ai.digital.deploy.cache.service.CacheDataService
import com.xebialabs.deployit.repository.sql.base.CiPKType
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util

@Service
class CiPkCacheDataService(@Autowired(required = false) override val cacheProvider: CacheProvider,
                           @Autowired cachesProperties: CachesProperties) extends CacheDataService[CiPKType, util.Map[String, Object]] {
  override val cacheName: String = "CI_PK_CACHE"
  override val cacheConfiguration: CacheConfiguration = cachesProperties.ciPkCacheConfiguration
}
