package com.xebialabs.deployit.repository.sql.reader.properties

import com.xebialabs.deployit.core.sql.SchemaInfo
import com.xebialabs.deployit.core.sql.spring.MapRowMapper
import com.xebialabs.deployit.repository.sql.base.{CiPKType, LookupValuesQueries}
import com.xebialabs.deployit.repository.sql.cache.{CiAppCacheContext, CiCacheDataServicesHolder}
import com.xebialabs.deployit.repository.sql.properties.{CiPropertiesQueries, PropertyTableRepository}
import com.xebialabs.deployit.repository.sql.specific.configurable.PropertyTableSelectDescriptor
import org.springframework.jdbc.core.JdbcTemplate

import java.util
import java.util.{List => JList, Map => JMap}
import scala.jdk.CollectionConverters._

/**
 * CI Data provider that loads CI data "on demand"
 * It does not pre-cache or batch any queries, so use it only when it's absolutely necessary and there are no other
 * options. It's always better to use `CiGroupCiDataProvider`
 *
 * @param jdbcTemplate - `org.springframework.jdbc.core.JdbcTemplate` instance
 * @param schemaInfo   - `com.xebialabs.deployit.core.sql.SchemaInfo` instance
 */
class OnDemandCiDataProvider(implicit val jdbcTemplate: JdbcTemplate, val schemaInfo: SchemaInfo)
  extends CiDataProvider with CiPropertiesQueries with LookupValuesQueries with PropertyTableRepository with CiPropertiesWithRefsProvider {
  override def getProperties(pk: CiPKType): util.List[util.Map[String, AnyRef]] = {
    if (CiAppCacheContext.useCache && CiCacheDataServicesHolder.getCachesProperties.enabled) {
      getCiPropertiesWithRefs(pk)
    } else {
      jdbcTemplate.query(SELECT_PROPERTIES_WITH_REFS, MapRowMapper, pk)
    }
  }

  override def getLookupValues(pk: CiPKType): util.List[util.Map[String, AnyRef]] =
    jdbcTemplate.query(SELECT_LOOKUP_VALUES, MapRowMapper, pk)

  override def getPropertyTableValues(id: CiPKType,
                                      selectDescriptor: PropertyTableSelectDescriptor): JList[JMap[String, AnyRef]] =
    readPropertyTableForCis(id :: Nil, selectDescriptor).asJava
}
