package com.xebialabs.deployit.repository.sql.reader.properties

import com.xebialabs.deployit.repository.sql.base.CiPKType
import com.xebialabs.deployit.repository.sql.specific.configurable.PropertyTableSelectDescriptor

import java.util.{List => JList, Map => JMap}

/**
 * This interface is an abstraction that allows us to control the process of CI data retrieval
 */
trait CiDataProvider {
  /**
   * Retrieves configuration item properties by CI id
   *
   * @param id - configuration item id
   * @return list of configuration properties maps (raw data)
   */
  def getProperties(id: CiPKType): JList[JMap[String, AnyRef]]

  /**
   * Retrieves configuration item lookup values by CI id
   *
   * @param id - configuration item id
   * @return list of configuration item lookup maps (raw data)
   */
  def getLookupValues(id: CiPKType): JList[JMap[String, AnyRef]]

  /**
   * Retrieves list of values based on query descriptor for PropertyTableReader
   *
   * @param id - configuration item primary key
   * @param selectDescriptor - query descriptor that will be used to build and execute a query for PropertyTableReader
   * @return list of rows represented as maps
   */
  def getPropertyTableValues(id: CiPKType, selectDescriptor: PropertyTableSelectDescriptor): JList[JMap[String, AnyRef]]
}
