package com.xebialabs.deployit.repository.sql.cache.queue

import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jms.core.JmsTemplate
import com.xebialabs.xldeploy.jms.adapter.CacheEvictionTopicNameResolver
import grizzled.slf4j.Logging
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.DependsOn
import org.springframework.stereotype.Service

@Service
@ConditionalOnProperty(prefix = "deploy.caches", name = Array("enabled"), havingValue = "true")
@DependsOn(value = Array("cacheMode"))
@Autowired
class CacheEvictionProducer(@Qualifier("mainJmsTemplate") jmsTemplate: JmsTemplate,
                         cacheEvictionTopicNameResolver: CacheEvictionTopicNameResolver) extends Logging{

  def sendEvictionInfo(info: Any): Unit = {
    try {
      logger.trace(s"Sending eviction message to nodes - $info")
      jmsTemplate.convertAndSend(cacheEvictionTopicNameResolver.getCacheEvictionTopicName, info)
    } catch {
      case exception: Exception =>
        logger.error("Exception occurred while sending cache eviction message to all nodes", exception)
    }
  }
}
