package com.xebialabs.deployit.repository.sql.commands

import com.xebialabs.deployit.checks.Checks
import com.xebialabs.deployit.sql.base.schema._

trait CiLengthValidation {

  protected def validateCiNameAndIdLengths(id: String): Unit = {
    validateCiNameLength(id.substring(id.lastIndexOf('/') + 1))
    validateCiIdLength(id)
  }

  private def validateCiNameLength(name: String): Unit = {
    Checks.checkArgument(name.length <= CIS.MAXIMUM_NAME_LENGTH, "Name %s is too long. Maximum length is %s", name, CIS.MAXIMUM_NAME_LENGTH)
  }

  private def validateCiIdLength(id: String): Unit = {
    Checks.checkArgument(id.length <= CIS.MAXIMUM_ID_LENGTH, "ID %s is too long. Maximum length is %s", id, CIS.MAXIMUM_ID_LENGTH)
  }
}