package com.xebialabs.deployit.repository.sql.lock

import java.util.concurrent.atomic.AtomicReference

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

/**
 * A holder class to hold the repository. This allows non-spring beans (i.e. POJOs and
 * Step classes) to get access to the CiLockRepository
 *
 * @param ciLockRepository Injected by spring
 */
@Component
class CiLockRepositoryHolder(@Autowired ciLockRepository: CiLockRepository) {
  CiLockRepositoryHolder.CiLockRepository.set(ciLockRepository)
}

object CiLockRepositoryHolder {
  private val CiLockRepository = new AtomicReference[CiLockRepository]

  def getCiLockRepository: CiLockRepository = CiLockRepositoryHolder.CiLockRepository.get()
}
