package com.xebialabs.deployit.repository.validation

import com.xebialabs.deployit.checks.Checks.checkArgument
import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistry, Type}
import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.repository.core.Directory

object DeployitCommandValidator extends CommandValidator {

  override def checkMoveAllowed(ciType: Type): Unit = {
    if (!(ciType == Type.valueOf(classOf[Directory])))
      checkArgument(!(DescriptorRegistry.getDescriptor(ciType).getRoot == Metadata.ConfigurationItemRoot.NESTED), "Can only move 'rooted' cis [%s]", ciType)
  }

  override def checkCopyAllowed(toBeCopiedParentType: Type, newParentType: Type): Unit = {
    checkArgument(toBeCopiedParentType == newParentType, "Target parent of copied ci must be of same type as that of the copied item [%s]", toBeCopiedParentType)
  }

}
