package com.xebialabs.deployit.repository.sql.specific.configurable

import com.xebialabs.deployit.core.sql.SelectBuilder
import com.xebialabs.deployit.repository.sql.base.CiPKType
import com.xebialabs.deployit.repository.sql.specific.TypeSpecificReferenceFinder
import com.xebialabs.deployit.repository.sql.specific.columns.PropertyColumnsReferenceFinder

class ConfigurableReferenceFinder(val pks: Seq[CiPKType], columns: Option[PropertyColumnsReferenceFinder], val tables: List[PropertyTableReferenceFinder] = List())
  extends TypeSpecificReferenceFinder {

  override def findReferences(): Seq[(CiPKType, CiPKType)] =
    tables.flatMap(_.findReferences(pks)) ++ columns.map(_.findReferences(pks)).getOrElse(Nil)

  override def findReferencesBuilders(): Seq[SelectBuilder] = {
    tables.flatMap(_.findReferencesBuilder(pks)) ++ columns.flatMap(_.findReferencesBuilder(pks))
  }
}
