package com.xebialabs.deployit.repository

import com.xebialabs.deployit.engine.api.dto.{ConfigurationItemId, Ordering, Paging}

trait DeployedApplicationsRepository {

  def find(deployedAppName: String, path: String, exactPath: Boolean): List[ConfigurationItemId]

  def count(deployedAppName: String, path: String, exactPath: Boolean): Int

  def findByEnvironment(envId: String, deployedAppName: String, paging: Paging, order: Ordering): List[ConfigurationItemId]

  def countByEnvironment(envId: String, deployedAppName: String): Int

  def findByHost(hostId: String, deployedAppName: String, paging: Paging, order: Ordering): List[ConfigurationItemId]

  def countByHost(hostId: String, deployedAppName: String): Int
}
