package com.xebialabs.deployit.repository.sql.persisters

import com.xebialabs.deployit.core.sql.{ColumnName, SchemaInfo, TableName}
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.repository.sql.specific.configurable.{ConfigurableTypeSpecificPersisterFactory, PropertyColumnsTable, TypeConfiguration}
import com.xebialabs.xlplatform.satellite.{Satellite, SatelliteGroup}
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class SatellitePersisterFactory (@Autowired @Qualifier("mainJdbcTemplate") implicit val jdbcTemplate: JdbcTemplate,
                                   @Autowired @Qualifier("mainSchema") implicit val schemaInfo: SchemaInfo)
  extends ConfigurableTypeSpecificPersisterFactory(classOf[Satellite]) {
  import SatelliteSchema._
  override val config: TypeConfiguration = new TypeConfiguration(
    Some(new PropertyColumnsTable(tableName, ID, Map("address" -> address, "protocolPort" -> protocolPort, "encrypted" -> encrypted)))
  )

  override protected def canHandle[T](t: Type): Boolean =
    t.instanceOf(Type.valueOf(classOf[Satellite])) && !t.instanceOf(Type.valueOf(classOf[SatelliteGroup]))
}

object SatelliteSchema {
  val tableName = TableName("XLD_SATELLITES")

  val ID = ColumnName("ID")
  val address = ColumnName("address")
  val protocolPort = ColumnName("protocolPort")
  val encrypted = ColumnName("encrypted")
}
