package com.xebialabs.deployit.repository.sql.persisters

import com.xebialabs.deployit.core.sql.{ColumnName, SchemaInfo, TableName}
import com.xebialabs.deployit.plugin.api.udm.Dictionary
import com.xebialabs.deployit.repository.sql.specific.configurable.{ConfigurableTypeSpecificPersisterFactory, TypeConfiguration}
import com.xebialabs.deployit.repository.sql.specific.tables.{MapStringStringPropertyTable, SetCiPropertyTable}
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class DictionaryPersisterFactory(@Autowired @Qualifier("mainJdbcTemplate") implicit val jdbcTemplate: JdbcTemplate,
                                 @Autowired @Qualifier("mainSchema") implicit val mainSchemaInfo: SchemaInfo)
  extends ConfigurableTypeSpecificPersisterFactory(classOf[Dictionary]) {
  override val config = new TypeConfiguration(
    None,
    Map(
      "entries" -> {
        import DictionaryEntriesSchema._
        new MapStringStringPropertyTable(tableName, dictionary_id, key, value)
      },
      "encryptedEntries" -> {
        import DictionaryEncryptedEntriesSchema._
        new MapStringStringPropertyTable(tableName, dictionary_id, key, value)
      },
      "restrictToContainers" -> {
        import DictionaryContainersSchema._
        new SetCiPropertyTable(tableName, dictionary_id, container_id)
      },
      "restrictToApplications" -> {
        import DictionaryApplicationsSchema._
        new SetCiPropertyTable(tableName, dictionary_id, application_id)
      }
    )
  )

}

object DictionaryEntriesSchema {
  val tableName: TableName = TableName("XLD_DICT_ENTRIES")

  val dictionary_id: ColumnName = ColumnName("dictionary_id")
  val key: ColumnName = ColumnName("key")
  val value: ColumnName = ColumnName("value")
}

object DictionaryEncryptedEntriesSchema {
  val tableName: TableName = TableName("XLD_DICT_ENC_ENTRIES")

  val dictionary_id: ColumnName = ColumnName("dictionary_id")
  val key: ColumnName = ColumnName("key")
  val value: ColumnName = ColumnName("value")
}

object DictionaryContainersSchema {
  val tableName: TableName = TableName("XLD_DICT_CONTAINERS")

  val dictionary_id: ColumnName = ColumnName("dictionary_id")
  val container_id: ColumnName = ColumnName("container_id")
}

object DictionaryApplicationsSchema {
  val tableName: TableName = TableName("XLD_DICT_APPLICATIONS")

  val dictionary_id: ColumnName = ColumnName("dictionary_id")
  val application_id: ColumnName = ColumnName("application_id")
}
