package com.xebialabs.deployit.repository.sql

import com.xebialabs.deployit.core.sql.{ColumnName, Queries, SchemaInfo, TableName}
import com.xebialabs.deployit.repository.XlMetadataRepository
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.dao.EmptyResultDataAccessException
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component
import org.springframework.transaction.annotation.Transactional

@Component
@Transactional("mainTransactionManager")
class SqlXlMetadataRepository(@Autowired @Qualifier("mainJdbcTemplate") val jdbcTemplate: JdbcTemplate)
                             (@Autowired @Qualifier("mainSchema") implicit val schemaInfo: SchemaInfo)
  extends XlMetadataRepository with XlMetadataQueries {

  override def save(name: String, value: String): Unit = {
    try {
      jdbcTemplate.update(INSERT, name, value)
    } catch {
      case e: Exception => throw new RuntimeException(s"Error saving metadata with name $name", e)
    }
  }

  override def get(name: String): String = {
    try {
      jdbcTemplate.queryForObject(SELECT, classOf[String], name)
    } catch {
      case _: EmptyResultDataAccessException => null
      case e: Exception => throw new RuntimeException(s"Error while retrieving metadata with name $name", e)
    }
  }
}

  object XlMetadataSchema {
    val tableName: TableName = TableName("XL_METADATA")

    val name: ColumnName = ColumnName("name")
    val value: ColumnName = ColumnName("value")
  }

  trait XlMetadataQueries extends Queries {

    import XlMetadataSchema._

    val SELECT = sqlb"select $value from $tableName where $name = ?"
    val INSERT = sqlb"insert into $tableName ($name, $value) values (?, ?)"

  }
