package com.xebialabs.deployit.repository.sql.placeholders

import com.xebialabs.deployit.core.sql.{ColumnName, SqlFunction, SqlCondition => cond}

object ConditionsBuilder {
  def createConditions(entries: Seq[(Option[String], ColumnName)]): Option[List[cond]] = {
    val conditions = entries.foldLeft(List[cond]())((acc: List[cond], entry: (Option[String], ColumnName)) => {
      entry._1 match {
        case Some(pattern) if pattern.nonEmpty =>
          acc.::(cond.likeEscaped(SqlFunction.lower(entry._2), s"%$pattern%".toLowerCase()))
        case _ => acc
      }
    })

    if (conditions.isEmpty) None else Some(conditions)
  }
}

object EnvironmentPlaceholderSearchParams {
  def createConditions(key: Option[String], value: Option[String], dictionary: Option[String],
                       deployedApplication: Option[String], host: Option[String]): Option[List[cond]] =
    ConditionsBuilder.createConditions(
      List(
        (key, PlaceholdersSchema.key),
        (value, PlaceholdersSchema.value),
        (dictionary, PlaceholdersSchema.dictionaryName),
        (deployedApplication, PlaceholdersSchema.deployedAppName),
        (host, PlaceholdersSchema.containerName)
      )
    )
}

object InfrastructurePlaceholderSearchParams {
  def createConditions(key: Option[String], value: Option[String], dictionary: Option[String],
                       deployedApplication: Option[String], environment: Option[String]): Option[List[cond]] =
    ConditionsBuilder.createConditions(
      List(
        (key, PlaceholdersSchema.key),
        (value, PlaceholdersSchema.value),
        (dictionary, PlaceholdersSchema.dictionaryName),
        (deployedApplication, PlaceholdersSchema.deployedAppName),
        (environment, PlaceholdersSchema.environmentName)
      )
    )
}
