package com.xebialabs.deployit.listener.placeholders

import com.xebialabs.deployit.engine.spi.event.{DeployitEventListener, _}
import com.xebialabs.deployit.repository.placeholders.PlaceholderRepositoryHolder
import com.xebialabs.deployit.repository.sql.placeholders.deployedApplicationType
import grizzled.slf4j.Logging
import nl.javadude.t2bus.Subscribe

import scala.jdk.CollectionConverters._

@DeployitEventListener
class ResolvedPlaceholderEventListener extends Logging {

  @Subscribe
  def onDelete(event: CisDeletedEvent): Unit = {
    val cis = event.getCis.asScala
    val resolvedPlaceholderRepository = PlaceholderRepositoryHolder.getResolvedPlaceholderRepository
    cis.foreach { ci =>
      logger.trace(s"Marking resolved placeholders as deleted for $ci.")

      ci match {
        case deployedApplicationType() =>
          val placeholders = resolvedPlaceholderRepository.getResolvedPlaceholder(ci.getId)
          resolvedPlaceholderRepository.markArchivedPlaceholderReferenceAsDeleted(ci, placeholders)
        case _ =>
          resolvedPlaceholderRepository.markArchivedPlaceholderReferenceAsDeleted(ci, List.empty)
      }
      resolvedPlaceholderRepository.markPlaceholderReferenceAsDeleted(ci)
    }
  }

  @Subscribe
  def onRename(event: CiRenamedEvent): Unit = {
    handlePathUpdate(oldPath(event), newPath(event))
  }

  @Subscribe
  def onMove(event: CiMovedEvent): Unit = {
    handlePathUpdate(oldPath(event), newPath(event))
  }

  private def handlePathUpdate(oldPath: String, newPath: String): Unit = {
    logger.trace(s"Updating reference for resolved placeholders $oldPath -> $newPath.")
    PlaceholderRepositoryHolder.getResolvedPlaceholderRepository.updatePlaceholderReferencePaths(oldPath, newPath)
  }
}
