package com.xebialabs.deployit.repository.sql.persisters

import com.xebialabs.deployit.core.sql.{ColumnName, SchemaInfo, TableName}
import com.xebialabs.deployit.repository.sql.specific.configurable.{ConfigurableTypeSpecificPersisterFactory, TypeConfiguration}
import com.xebialabs.deployit.repository.sql.specific.tables.SetCiPropertyTable
import com.xebialabs.xlplatform.satellite.SatelliteGroup
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class SatelliteGroupPersisterFactory(@Autowired @Qualifier("mainJdbcTemplate") implicit val jdbcTemplate: JdbcTemplate,
                                     @Autowired @Qualifier("mainSchema") implicit val schemaInfo: SchemaInfo)
  extends ConfigurableTypeSpecificPersisterFactory(classOf[SatelliteGroup]) {
  override val config: TypeConfiguration = new TypeConfiguration(
    None,
    Map(
      "satellites" -> {
        import SatelliteGroupSatellitesSchema._
        new SetCiPropertyTable(tableName, group_id, satellite_id)
      }
    )
  )
}

object SatelliteGroupSatellitesSchema {
  val tableName = TableName("XLD_SAT_GROUP_SATELLITES")

  val group_id = ColumnName("group_id")
  val satellite_id = ColumnName("satellite_id")
}
