package com.xebialabs.deployit.repository.sql.persisters

import com.xebialabs.deployit.core.sql.{ColumnName, SchemaInfo, TableName}
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.overthere.Host
import com.xebialabs.deployit.repository.sql.specific.configurable.{ConfigurableTypeSpecificPersisterFactory, PropertyColumnsTable, TypeConfiguration}
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class HostPersisterFactory(@Autowired @Qualifier("mainJdbcTemplate") implicit val jdbcTemplate: JdbcTemplate,
                                   @Autowired @Qualifier("mainSchema") implicit val mainSchemaInfo: SchemaInfo)
  extends ConfigurableTypeSpecificPersisterFactory(classOf[Host]) {
  import HostSchema._
  override val config: TypeConfiguration = new TypeConfiguration(
    Some(new PropertyColumnsTable(tableName, ID,
      Map(
        "os" -> os,
        "satellite" -> satellite_id,
        "address" -> address,
        "port" -> port,
        "username" -> username
      )
    ))
  )
  override protected def canHandle[T](t: Type): Boolean =
    t.instanceOf(Type.valueOf(classOf[Host])) && !t.instanceOf(Type.valueOf("overthere.LocalHost"))
}

object HostSchema {
  val tableName = TableName("XLD_HOSTS")

  val ID = ColumnName("ID")

  val os = ColumnName("os")
  val satellite_id = ColumnName("satellite_id")
  val address = ColumnName("address")
  val port = ColumnName("port")
  val username = ColumnName("username")
}
