package com.xebialabs.deployit.listener

import com.xebialabs.deployit.core.util.IdExtensions._
import com.xebialabs.deployit.engine.spi.event.{CiCopiedEvent, CiMovedEvent, CiRenamedEvent}
import com.xebialabs.deployit.repository.sql.base.idToPath

package object placeholders {

  private[placeholders] def newPath(event: CiRenamedEvent) = {
    idToPath(s"${event.getId.getParent}/${event.getNewName}")
  }

  private[placeholders] def oldPath(event: CiRenamedEvent) = {
    idToPath(event.getId)
  }

  private[placeholders] def newPath(event: CiMovedEvent) = {
    idToPath(event.getNewId)
  }

  private[placeholders] def oldPath(event: CiMovedEvent) = {
    idToPath(event.getEntity)
  }

  private[placeholders] def newPath(event: CiCopiedEvent) = {
    idToPath(event.getNewId)
  }

  private[placeholders] def oldPath(event: CiCopiedEvent) = {
    idToPath(event.getCi.getId)
  }

}
